require 'common'
-- physical parameter ---------------------------------------------------------
initial_condition = {
  density = dens, 
  velocityX = velocityX,
  velocityY = velocityY,
  pressure = gauss_press, 
}

-- simulation controll parameter-----------------------------------------------
simulation_name='ateles_navier' 
timing_file = 'timing_navier.res'

-- table for preCICE
precice = {
           accessor = 'Ateles_navier',
           configFile ='precice.xml',
          }

-- Restart -------------------------------------------------------------------
restart = {
--  read = './restart/navier/ateles_navier_header_200.000E-03.lua',
  write = './restart/navier/',
  time_control = {
    min = 0, 
    max = tmax, 
    interval = track_dt
  },
}

-- Tracking -------------------------------------------------------------------
--ply_sampling = { nlevels = 2}
tracking = {
  { -- GLobal VTK
    label = 'global',
    folder = './track/navier/',
    variable = {'density', 'momentum', 'energy', 'velocity', 'pressure'},
    shape = {
      { kind = 'all',}
    },
    time_control = {min = 0, max = tmax, interval = track_dt},
    output={format = 'vtk'},
  },
}

-- Simulation parameter -------------------------------------------------------
mesh = 'mesh_navier_split/'

-- Variable system definintion-------------------------------------------------
characteristic = 0.0
function relax_velocity(x,y,z,t)
  return {0.0, 0.0}
end
relax_temperature = 0.0

variable = {
  {
     name = 'characteristic',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = characteristic
  },
  {
     name = 'relax_velocity',
     ncomponents = 2,
     vartype = "st_fun",
     st_fun = relax_velocity
  },
  {
     name = 'relax_temperature',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_temperature
  },
  {
     name = 'coupling_fluid',
     ncomponents = 12,
     vartype = 'st_fun',
     st_fun = { 
       predefined = 'precice',
       precice_mesh = 'Fluid_Surface_navier',
       write_varname = {'density_navier', 
                        'velX_navier', 
                        'velY_navier', 
                        'pressure_navier'},
       read_varname = {'density_euler_fluid', 
                       'velX_euler_fluid', 
                       'velY_euler_fluid', 
                       'pressure_euler_fluid',
                       'gradX_density_euler_fluid',
                       'gradX_velX_euler_fluid',
                       'gradX_velY_euler_fluid',
                       'gradX_pressure_euler_fluid',
                       'gradY_density_euler_fluid',
                       'gradY_velX_euler_fluid',
                       'gradY_velY_euler_fluid',
                       'gradY_pressure_euler_fluid'},
    }          
  },
  -- write to precice
  {
     name = 'density_navier',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'density',
       input_varindex = {1}
     }          
  },
  {
     name = 'velX_navier',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'velocity',
       input_varindex = {1}
     }          
  },
  {
     name = 'velY_navier',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'velocity',
       input_varindex = {2}
     }          
  },
  {
     name = 'pressure_navier',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'pressure',
       input_varindex = {1}
     }          
  },
  -- read from precice
  {
     name = 'density_euler_fluid',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling_fluid',
       input_varindex = {1}
     }          
  },
  {
     name = 'velX_euler_fluid',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling_fluid',
       input_varindex = {2}
     }          
  },
  {
     name = 'velY_euler_fluid',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling_fluid',
       input_varindex = {3}
     }          
  },
  {
     name = 'pressure_euler_fluid',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling_fluid',
       input_varindex = {4}
     }          
  },
  {
     name = 'gradX_density_euler_fluid',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling_fluid',
       input_varindex = {5}
     }          
  },
  {
     name = 'gradX_velX_euler_fluid',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling_fluid',
       input_varindex = {6}
     }          
  },
  {
     name = 'gradX_velY_euler_fluid',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling_fluid',
       input_varindex = {7}
     }          
  },
  {
     name = 'gradX_pressure_euler_fluid',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling_fluid',
       input_varindex = {8}
     }          
  },
  {
     name = 'gradY_density_euler_fluid',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling_fluid',
       input_varindex = {9}
     }          
  },
  {
     name = 'gradY_velX_euler_fluid',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling_fluid',
       input_varindex = {10}
     }          
  },
  {
     name = 'gradY_velY_euler_fluid',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling_fluid',
       input_varindex = {11}
     }          
  },
  {
     name = 'gradY_pressure_euler_fluid',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'extract',
       input_varname = 'coupling_fluid',
       input_varindex = {12}
     }          
  },
}

-- Equation definitions -------------------------------------------------------
penalization_eps = 8.0/(degree+1)
penalization_alpha = 1.0
equation = {
  penalization = {
    global = {
      kind = 'const',
      const = {0.0, 0.0, 0.0, 0.0},
    },
  },
  name       = 'navier_stokes_2d',
  isen_coef  = 1.4,
  r          = 280.0,
  therm_cond = 0.5, 
  mu         = 1.0e-4,  
  ip_param   = 4.0, 
  -- Parameters of the penalization
  porosity             = penalization_eps,
  viscous_permeability = penalization_alpha*penalization_eps,
  thermal_permeability = penalization_alpha*penalization_eps,
  material = {
    characteristic = 'characteristic',
    relax_velocity = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)


 -- Boundary definitions
boundary_condition = {
  {
    label = 'fluid_east',
    kind = 'grad_primitives',
    density = 'density_euler_fluid',
    velocityX = 'velX_euler_fluid', 
    velocityY = 'velY_euler_fluid',
    pressure  = 'pressure_euler_fluid',
    grad_density   = 'gradX_density_euler_fluid',
    grad_velocityX = 'gradX_velX_euler_fluid', 
    grad_velocityY = 'gradX_velY_euler_fluid',
    grad_pressure  = 'gradX_pressure_euler_fluid',
  },
  {
    label = 'fluid_west',
    kind = 'grad_primitives',
    density = 'density_euler_fluid',
    velocityX = 'velX_euler_fluid', 
    velocityY = 'velY_euler_fluid',
    pressure = 'pressure_euler_fluid',
    grad_density   = 'gradX_density_euler_fluid',
    grad_velocityX = 'gradX_velX_euler_fluid', 
    grad_velocityY = 'gradX_velY_euler_fluid',
    grad_pressure  = 'gradX_pressure_euler_fluid',
  },
  {
    label = 'fluid_north',
    kind = 'grad_primitives',
    density = 'density_euler_fluid',
    velocityX = 'velX_euler_fluid', 
    velocityY = 'velY_euler_fluid',
    pressure = 'pressure_euler_fluid',
    grad_density   = 'gradY_density_euler_fluid',
    grad_velocityX = 'gradY_velX_euler_fluid', 
    grad_velocityY = 'gradY_velY_euler_fluid',
    grad_pressure  = 'gradY_pressure_euler_fluid',
  },
  {
    label = 'fluid_south',
    kind = 'grad_primitives',
    density = 'density_euler_fluid',
    velocityX = 'velX_euler_fluid', 
    velocityY = 'velY_euler_fluid',
    pressure = 'pressure_euler_fluid',
    grad_density   = 'gradY_density_euler_fluid',
    grad_velocityX = 'gradY_velX_euler_fluid', 
    grad_velocityY = 'gradY_velY_euler_fluid',
    grad_pressure  = 'gradY_pressure_euler_fluid',
  },
  {
    label = 'fluid_top',
    kind = 'outflow',
    pressure = press,
  },
  {
    label = 'fluid_bottom',
    kind = 'outflow',
    pressure = press,
  },
}
