require 'common'
-- physical parameter ---------------------------------------------------------
initial_condition = {
  density = 0.0, 
  velocityX = 0.0,
  velocityY = 0.0,
  pressure = 0.0, 
}
bg_dens = dens
bg_velX = velocityX
bg_velY = velocityY
bg_press = press

-- simulation controll parameter-----------------------------------------------
simulation_name='ateles_lineuler'
timing_file = 'timing_lineuler.res'

-- Restart  -------------------------------------------------------------------
restart = {
  read  = './restart/lineuler/ateles_lineuler_header_200.000E-03.lua',
  write = './restart/lineuler/',
  time_control = {
    min = 0, 
    max = tmax, 
    interval = track_dt
  },
}

-- Tracking -------------------------------------------------------------------
NOtracking = {
  { -- GLobal VTK
    label = 'global',
    folder = './track/lineuler/',
    variable = {'density', 'velocity', 'pressure', 'completeState'},
    shape = {
      { kind = 'all',}
    },
    time_control = {min = 0, max = tmax, interval = track_dt},
    output={format = 'vtk'},
  },
}

-- Simulation parameter -------------------------------------------------------
mesh = 'mesh_lineuler/'

-- Variable system definintion-------------------------------------------------

variable = {
  -- add the background to varSys
  {
    name = 'bg_density',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun =  bg_dens,  
  },
  {
    name = 'bg_velocity',
    ncomponents = 2,
    vartype = 'st_fun',
    st_fun =  {bg_velX, bg_velY}  
  },
  {
    name = 'bg_pressure',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun =  bg_press,  
  },
}


-- Equation definitions -------------------------------------------------------
equation = {
  name = 'LinearEuler_2d',
  therm_cond = 2.555e-02,
  isen_coef = 1.4,
  background = {
    density =  bg_dens,
    velocityX = bg_velX,
    velocityY = bg_velY,
    pressure = bg_press
  }
}

 -- Boundary definitions
boundary_condition = {
  {
    label = 'acoustic',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0, 
    velocityY = 0.0,
    pressure = 0.0,
  }
  ,
  {
    label = 'outside',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0, 
    velocityY = 0.0,
    pressure = 0.0,
  }
}
