require 'common'
-- physical parameter ---------------------------------------------------------
initial_condition = {
  density = dens, 
  velocityX = velocityX,
  velocityY = velocityY,
  pressure = press, 
}

-- simulation controll parameter-----------------------------------------------
simulation_name='ateles_euler'
timing_file = 'timing_euler.res'

-- table for preCICE
precice = {
           accessor = 'Ateles_euler',
           configFile ='precice.xml',
          }

-- Restart  -------------------------------------------------------------------
restart = {
--  read  = './restart/euler/ateles_euler_header_200.000E-03.lua',
  write = './restart/euler/',
  time_control = {
    min = 0, 
    max = tmax, 
    interval = track_dt
  },
}

-- Tracking -------------------------------------------------------------------
--ply_sampling = { nlevels = 2}
tracking = {
  { -- GLobal VTK
    label = 'global',
    folder = './track/euler/',
    variable = {'density', 'momentum', 'energy', 'velocity', 'pressure', 
                'grad_density', 'grad_velocity', 'grad_pressure' },
    shape = {
      { kind = 'all',}
    },
    time_control = {min = 0, max = tmax, interval = track_dt},
    output={format = 'vtk'},
  },
}

-- Simulation parameter -------------------------------------------------------
mesh = 'mesh_euler/'

-- Variable system definintion-------------------------------------------------
characteristic = 0.0
function relax_velocity(x,y,z,t)
  return {0.0, 0.0}
end
relax_temperature = 0.0

variable = {
  {
    name = 'characteristic',
    ncomponents = 1,
    vartype = "st_fun",
    st_fun = characteristic,
  },
  {
    name = 'relax_velocity',
    ncomponents = 2,
    vartype = "st_fun",
    st_fun = relax_velocity,
  },
  {
    name = 'relax_temperature',
    ncomponents = 1,
    vartype = "st_fun",
    st_fun = relax_temperature,
  },
  {
    name = 'grad_velocity',
    ncomponents = 4,
    vartype = 'operation',
    operation = {
      kind = 'gradient',
      input_varname = 'velocity',
    }          
  },
  -- we have to coupling surface:
  {
    name = 'coupling_fluid',
    ncomponents = 12,
    vartype = 'st_fun',
    st_fun = { 
      predefined = 'precice',
      precice_mesh = 'Fluid_Surface_euler',
      write_varname = {'density_euler_fluid', 
                       'velX_euler_fluid', 
                       'velY_euler_fluid', 
                       'pressure_euler_fluid',
                       'gradX_density_euler_fluid',
                       'gradX_velX_euler_fluid',
                       'gradX_velY_euler_fluid',
                       'gradX_pressure_euler_fluid',
                       'gradY_density_euler_fluid',
                       'gradY_velX_euler_fluid',
                       'gradY_velY_euler_fluid',
                       'gradY_pressure_euler_fluid'},
      read_varname = {'density_navier', 
                       'velX_navier', 
                       'velY_navier', 
                       'pressure_navier'},
    },          
  },
  {
    name = 'coupling_acoustic',
    ncomponents = 4,
    vartype = 'st_fun',
    st_fun = { 
      predefined = 'precice',
      precice_mesh = 'Acoustic_Surface_euler',
      write_varname = {'density_euler_acoustic', 
                       'velX_euler_acoustic', 
                       'velY_euler_acoustic', 
                       'pressure_euler_acoustic'
                      },
      read_varname = {'density_lineuler', 
                       'velX_lineuler', 
                       'velY_lineuler', 
                       'pressure_lineuler'},
    }          
  },
  --write to precice on fluid surface  for fluid
  {
    name = 'density_euler_fluid',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'density',
      input_varindex = {1}
    }          
  },
  {
    name = 'grad_density',
    ncomponents = 2,
    vartype = 'operation',
    operation = {
      kind = 'gradient',
      input_varname = 'density',
    }          
  },
  {
    name = 'gradX_density_euler_fluid',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'grad_density',
      input_varindex = {1}
    }          
  },
  {
    name = 'gradY_density_euler_fluid',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'grad_density',
      input_varindex = {2}
    }          
  },
  {
    name = 'velX_euler_fluid',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'velocity',
      input_varindex = {1}
    }          
  },
  {
    name = 'gradX_velX_euler_fluid',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'grad_velocity',
      input_varindex = {1}
    }          
  },
  {
    name = 'gradY_velX_euler_fluid',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'grad_velocity',
      input_varindex = {2}
    }          
  },
  {
    name = 'velY_euler_fluid',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'velocity',
      input_varindex = {2}
    }          
  },
  {
    name = 'gradX_velY_euler_fluid',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'grad_velocity',
      input_varindex = {3}
    }          
  },
  {
    name = 'gradY_velY_euler_fluid',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'grad_velocity',
      input_varindex = {4}
    }          
  },
  {
    name = 'pressure_euler_fluid',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'pressure',
      input_varindex = {1}
    }          
  },
  {
    name = 'grad_pressure',
    ncomponents = 2,
    vartype = 'operation',
    operation = {
      kind = 'gradient',
      input_varname = 'pressure',
    }          
  },
  {
    name = 'gradX_pressure_euler_fluid',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'grad_pressure',
      input_varindex = {1}
    }          
  },
  {
    name = 'gradY_pressure_euler_fluid',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'grad_pressure',
      input_varindex = {2}
    }          
  },
  --write to precice on fluid surface  for acoustic
  {
    name = 'density_euler_acoustic',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'density',
      input_varindex = {1}
    }          
  },
  {
    name = 'velX_euler_acoustic',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'velocity',
      input_varindex = {1}
    }          
  },
  {
    name = 'velY_euler_acoustic',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'velocity',
      input_varindex = {2}
    }          
  },
  {
    name = 'pressure_euler_acoustic',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'pressure',
      input_varindex = {1}
    }          
  },
  --read from precice on fluid surface
  {
    name = 'density_navier',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling_fluid',
      input_varindex = {1}
    }          
  },
  {
    name = 'velX_navier',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling_fluid',
      input_varindex = {2}
    }          
  },
  {
    name = 'velY_navier',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling_fluid',
      input_varindex = {3}
    }          
  },
  {
    name = 'pressure_navier',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling_fluid',
      input_varindex = {4}
    }          
  },
  --read from precice on acoustic surface
  {
    name = 'density_lineuler',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling_acoustic',
      input_varindex = {1}
    }          
  },
  {
    name = 'velX_lineuler',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling_acoustic',
      input_varindex = {2}
    }          
  },
  {
    name = 'velY_lineuler',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling_acoustic',
      input_varindex = {3}
    }          
  },
  {
    name = 'pressure_lineuler',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling_acoustic',
      input_varindex = {4}
    }          
  },
}

-- Equation definitions -------------------------------------------------------
penalization_eps = 8.0/(degree+1)
penalization_alpha = 1.0
equation = {
  penalization = {
    global = {
      kind = 'const',
      const = {0.0, 0.0, 0.0, 0.0},
    },
  },
  name       = 'euler_2d',
  isen_coef  = 1.4,
  r          = 280.0,
  material = {
    characteristic = 'characteristic',
    relax_velocity = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)


 -- Boundary definitions
boundary_condition = {
  {
    label = 'acoustic',
    kind = 'primitives',
    density = 'density_lineuler',
    velocityX = 'velX_lineuler', 
    velocityY = 'velY_lineuler',
    pressure = 'pressure_lineuler',
  }
  ,
  {
    label = 'fluid',
    kind = 'primitives',
    density = 'density_navier',
    velocityX = 'velX_navier', 
    velocityY = 'velY_navier',
    pressure = 'pressure_navier',
  }
}
