-- Configuration file for Ateles --
require 'seeder_2d_medium'

-- Scheme definitions --
filter_order = 14
degree =11 --32

-- global simulation options
simulation_name = 'jet_euler_modg'
sim_control = {
              time_control  = {
                                max = {iter = 1000000}, 
                                interval = { iter=1000 },
                              },
             }

logging = { level = 5 }

check = {
          interval = 1,
        }

----...Info for precice
precice = {
           accessor = 'Ateles_euler',
           configFile ='precice_config_new.xml',
          }

-- Mesh definitions --
mesh = './mesh_2d_medium/'


-- Restart settings
restart = { 
--            read = './restart_medium/euler_coupled/jet_euler_modg_header_6.500E-03.lua',
            write = './restart_medium/euler_coupled/',                                        
            time_control = {   
                             min = 0, 
                             max = sim_control.time_control.max, 
                             interval = {iter=500}, --sim_control.time_control.max.iter/50,
                           },  
          }

-- the filename of the timing results i.e. output for performance measurements
timing_file = 'timing.res'        

-- Equation definitions --
equation = {
    name   = 'euler_2d',
    therm_cond = 2.555e-02,
    isen_coef = 1.4,
    r      = 296.0,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

scheme = {
    -- the spatial discretization scheme
    spatial =  {
                  name = 'modg_2d',            -- we use the modal discontinuous Galerkin scheme 
                --  m= { { level = 6,     m = degree },
                --       { level = 7,   m = degree },
                --       { level = 8,   m = degree },
                --     }
                  m = degree,        -- the maximal polynomial degree for each spatial direction
               }, 
               
    stabilization = {
                      {
                          name = 'spectral_viscosity',
                          alpha = 36,
                          order = filter_order,
                       },
                       {
                           name = 'covolume',
                           alpha = 36,
                           order = filter_order,
                           beta = 1.0 - 2.0/(degree+1),
                       },
                     },
--    stabilization = {
--                      {
--                       name = 'spectral_viscosity',
--                       alpha = 36,
--                       order = 10,
--                      },
--                    },
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitSSPRungeKutta', 
               steps = 2,
               control = {
                          name = 'cfl', 
                          cfl  = 0.95, 
                         },
               },
}

-- The ambient medium
press = 1
dens = 1

-- the Mach number of the jet
mach = 0.4

-- the velocity amplitude in z direction
velAmpl = mach*math.sqrt(equation.isen_coef*press/dens) -- 0.1
densAmpl = 2.0


-- the radius of the jet
jet_radius = 0.1
jet_center = 1.5+1e-4
--jet_center = 1e-4
momentum_thickness = jet_radius/20

-- tanh function
function tanh(x)
nu = 1 - math.exp(-2*x)
de = 1 + math.exp(-2*x)
return nu/de
end

function velX_inlet(x,y,z,t)
  r = math.sqrt( (y-jet_center)*(y-jet_center) )
  return velAmpl * (1/2) * ( 1 + tanh((jet_radius-r)/(2*momentum_thickness) ) )
end 

function dens_inlet(x,y,z,t)
  r = math.sqrt( (y-jet_center)*(y-jet_center) )
  if r < 2*jet_radius then
    tmpVel = velX_inlet(x,y,z,t)/velAmpl
    return densAmpl / ( 1 + (equation.isen_coef-1)/2*mach*mach*tmpVel*(1-tmpVel)  )
  else
    return dens
  end
end


--TODO -- random number for x and y velocity at initial time 
--TODO math.randomseed(1234)
--TODO function velXYIni(x,y,z)
--TODO   r = math.sqrt( x*x + y*y )
--TODO   return velAmpl * 1e-06 * math.exp( (-3/jetwidth) * r ) * ( math.tanh( -D * ( z - minzcoord) ) + 1.0 ) * math.random()
--TODO end

-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = dens,
                      pressure = press,
                      velocityX = 0.0,
                      velocityY = 0.0,
                    }

-- ...the general projection table
projection = {
              kind = 'fpt',  
              factor = 1.0,          
--              lobattoPoints=true,
             }


-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'inflowWest',  
                       kind = 'inflow_normal',      
                       density = dens_inlet,
                       v_norm = velX_inlet,
                       v_tan = 0.0,
                       }
                       ,
                       { 
                       label = 'outflowEast',  
                       kind = 'outflow',       
                       pressure = press,
                       }
                       ,
                       { 
                       label = 'outflowNorth', 
                       kind = 'precice',
                       precice_mesh = 'EulerSurface',
                       exchange_data_write =  {'Density_euler', 
                                               'Vel_X_euler', 
                                               'Vel_Y_euler', 
                                               'Pressure_euler'
                                               },
                       exchange_data_read =  {'Density_acoustic', 
                                              'Vel_X_acoustic', 
                                              'Vel_Y_acoustic', 
                                              'Pressure_acoustic'
                                             }
                       }
                       ,
                       { 
                       label = 'outflowSouth', 
                       kind = 'precice',
                       precice_mesh = 'EulerSurface',
                       exchange_data_write =  {'Density_euler', 
                                               'Vel_X_euler', 
                                               'Vel_Y_euler', 
                                               'Pressure_euler'
                                               },
                       exchange_data_read =  {'Density_acoustic', 
                                              'Vel_X_acoustic', 
                                              'Vel_Y_acoustic', 
                                              'Pressure_acoustic'
                                             }
                       }
                       ,
                       { 
                       label = 'wallTop', 
                       kind = 'outflow',       
                       pressure = press,
                       }
                       ,
                       { 
                       label = 'wallBottom', 
                       kind = 'outflow',       
                       pressure = press,
                       }
                     }  
precice_write = {  label = {'outflowSouth','outflowNorth' }}
source = {
  spongeLayer = {
    shape = {
      kind = 'canoND', 
      object= {
        origin = { x - 0.1 + eps, -eps, -eps },

        vec = {
          { 0.1, 0, 0 },
          { 0, y, 0 },
          { 0, 0, elemsize }
        },
        segments = { 200, 200, 10 }
      }
    },
    kind = 'combined',
    spatial = { 
      predefined = 'spongeLayer_2d', 
      plane_origin = { x - 0.1 + eps, 0.0, 0 },
      --plane_origin = {bounding_cube.length-3*elemsize,0.0,0},
      plane_normal = {1.0,0,0},
      damp_factor = 50,
      damp_exponent = 2,
      target_state = {
        density = dens,
        velx = 0.0,
        vely = 0.0,
        pressure = press
      } 
    }
  }
}
--debug = { 
--         debugMode = true,        -- default= false
--         verbose = 3,             -- default= 0
--
--         -- Use a logging object to track output in individual files.
--         -- The output messages to this logging object are usually
--         -- generated by tem_debug calls.
--         logging = { level = 1, -- how detailed should the log be?
--                     filename = 'dbg', -- to which file to write the log
--                     root_only = false }, -- should only root write msgs?
--
--         debugFiles = true,       -- default= false
--         -- What to dump into debugFiles? --
--        --   dumpTreeIDs = true,      -- default= false
--        --   dumpPropBits = true,     -- default= false
--        --   dumpAuxLists = true,     -- default= false
--        --   dumpDependencies = true, -- default= false
--        --   dumpState = true,        -- default= false
--        --   dumpHaloState = true,    -- default= false
--        -- --  end debugFiles  --
--        -- debugDependencies = true, -- default= false
--        -- checkDependencies = true, -- default= false
--        -- checkNans = true,         -- default= false
--        -- checkSteps = true,        -- default= false
--        -- debugMesh = 'dbg/mesh_',  -- default= ''
--        -- debugSource = true,       -- default= false
--        -- debugRestart = true,      -- default= false
--        -- traceMemory = true,       -- default= false
--        }
