-- Use this file as template. Do not modify this file for running some testcases

outputname = 'acoustic'
outputpreview = true 
folder = 'mesh_acoustic/'

minlevel = 3
maxlevel = 3

cubeLength = 6.0

--debug = { debugMode = true, debugMesh = 'debug/' }
-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {cubeLength/(-2.0),cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }

geom_level=minlevel
small_level = minlevel+5
--plate_level = minlevel

-- smallness parameter
eps = bounding_cube.length/(2^small_level)

-- the element size around the plate
--smalleps = bounding_cube.length/(2^plate_level)

-- the element size of the largest elements (belonging to minlevel)
largeeps = bounding_cube.length/(2^minlevel)

spatial_object = 
                {
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {0.0, -1.0, -1.0},

                                        },
                             },
                  },
                  -- eastern acoustic bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_East',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                  -eps,
                                                  -2*largeeps-eps,
                                                  -2*largeeps-eps,
                                                  -- -1.5-largeeps, 
                                                  -- -1.0-largeeps, 
                                                  -- -1.0-largeeps,
                                                  },
                                          },
                              }
                  },
                  -- western outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_West',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   2*largeeps+eps,
                                                  -2*largeeps-eps,
                                                  -2*largeeps-eps,
                                                   -- 1.5+largeeps, 
                                                   -- -1.0-largeeps, 
                                                   -- -1.0-largeeps,
                                                  },
                                          },
                              }
                  },
                  -- southern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_South',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                  -eps,
                                                  -2*largeeps-eps,
                                                  -2*largeeps-eps,
                                                  -- -1.5-largeeps, 
                                                  -- -1.0-largeeps, 
                                                  -- -1.0-largeeps,
                                                  },
                                          },
                              }
                  },
                  -- northern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_North',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                  -eps,
                                                  3*largeeps+eps,
                                                  -2*largeeps-eps,
                                                  -- -1.5-largeeps, 
                                                  -- 1.25+largeeps, 
                                                  -- -1.0-largeeps,
                                                  },
                                          },
                              }
                  },
                  -- bottom slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_Bottom',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                  -eps,
                                                  -2*largeeps-eps,
                                                  -2*largeeps-eps,
                                                  -- -1.5-largeeps, 
                                                  -- -1.0-largeeps, 
                                                  -- -1.0-largeeps,
                                                  },
                                          },
                              }
                  },
                  -- top slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_Top',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                  -eps,
                                                  -3*largeeps-eps,
                                                  3*largeeps+eps,
                                                  -- -1.5-largeeps, 
                                                  -- -1.0-largeeps, 
                                                  -- 1.25+largeeps,
                                                  },
                                          },
                              }
                  },
                  -- the euler box inside
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'euler',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {largeeps+2*eps,0.0,0.0},
                                                  {0.0,largeeps-2*eps,0.0},
                                                  {0.0,0.0,largeeps-2*eps},
                                                },
                                           origin={
                                                   eps,
                                                   eps,
                                                   eps,
                                                  --   (-1)*bounding_cube.length/2+largeeps,
                                                  --   (-1)*bounding_cube.length/2+largeeps,
                                                  --   (-1)*bounding_cube.length/2+largeeps,
                                                  },
                                          },
                              }
                  },
                }
	    
