-- Configuration file for Ateles --
require 'seeder_acoustic'
logging = { level = 10 }

degree=3

-- global simulation options
simulation_name = 'jet_acoustic_modg'             -- the name of the simualtion
sim_control = {
		time_control = { min = 0.0,
                                 max = {iter=1000} ,      -- final simulation time
                                 interval = {iter=100},
                                },
               }

check = {
          interval = 10,
        }

--...Info for precice
precice = {
           accessor = 'Ateles_acoustic',
           configFile ='precice_config_mpi.xml',
          }


-- Mesh definitions --
mesh = './mesh_acoustic/'


-- Restart settings
restart = { 
--            -- file to restart from
--            read = './restart/04_m12_o18/jet_euler_modg_lastHeader.lua',                        
--            -- folder to write restart data to
            write = './restart/acoustic/',                                        
            -- temporal definition of restart write
            time_control = {   
                            min = 0, 
                            max = {iter=1000},                  -- final simulation time
                            interval = {iter=10}
                           },  
          }


-- the filename of the timing results i.e. output for performance measurements
timing_file = 'timing.res'        

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
                 name = 'modg',            -- we use the modal discontinuous Galerkin scheme 
                 m =  degree,
               }, 
    -- the temporal discretization scheme
    temporal = {
                 name = 'explicitSSPRungeKutta',  --'explicitEuler',
                 steps = 2,
                 -- how to control the timestep
                 control = {
                             name = 'cfl',   -- the name of the timestep control mechanism
                             cfl  = 0.6,       -- CourantÐFriedrichsÐLewy number
                         },
               },
     }

-- The ambient medium
press = 1.0
dens = 1.0

-- the Mach number of the jet
mach = 0.4


-- Equation definitions --
equation = {
             name   = 'acoustic',
             background = {
                 density = dens, 
                 velocityX = 0.0,
                 velocityY = 0.0,
                 velocityZ = 0.0,
                 pressure = press
                 }
           }

-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = 0.0,    --dens,
                      pressure = 0.0,   --press,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0, 
                    }


-- ...the general projection table
projection = {
              kind = 'l2p',  -- 'fpt' or 'l2p', default 'l2p'
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
          --    blocksize = 32,
          --    lobattoPoints=true,
           -- fftmultithread = false -- for fpt, logical, default false
             }

-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'euler',  
                       kind = 'precice',
                       precice_mesh = 'AcousticSurface',
                       provide_mesh = true,
                       exchange_data_write =  {'Density_acoustic', 
                                               'Vel_X_acoustic', 
                                               'Vel_Y_acoustic', 
					                                     'Vel_Z_acoustic', 
                                               'Pressure_acoustic' 
                                               },
                       exchange_data_read =  {'Density_euler', 
                                              'Vel_X_euler', 
                                              'Vel_Y_euler', 
                                              'Vel_Z_euler'}
                       
                       },
                       { 
                       label = 'acoustic_East',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'acoustic_West',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'acoustic_South',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'acoustic_North',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'acoustic_Bottom',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'acoustic_Top',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                     }  

precice_write = {  label = {'euler'}}
