-- Use this file as template. Do not modify this file for running some testcases

outputname = 'euler'
outputpreview = true 
folder = 'mesh_acoustic/'

level = 3
maxlevel = 3
minlevel = 3

cubeLength = 8.0

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {cubeLength/(-2.0),cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }


-- the element size of the largest elements (belonging to minlevel)
eps = bounding_cube.length/(2^level+1)
largeeps = bounding_cube.length/(2^level)

spatial_object = 
                {
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {2*largeeps+eps,2*largeeps+eps,2*largeeps+eps},

                                        },
                             },
                  },
                  -- eastern acoustic bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_East',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    -4*largeeps-eps, 
                                                    -4*largeeps-eps, 
                                                    -4*largeeps-eps, 
                                                  },
                                          },
                              }
                  },
                  -- western outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_West',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    4*largeeps+eps, 
                                                    -4*largeeps-eps, 
                                                    -4*largeeps-eps, 
                                                  },
                                          },
                              }
                  },
                  -- southern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_South',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    -4*largeeps-eps, 
                                                    -4*largeeps-eps, 
                                                    -4*largeeps-eps, 
                                                  },
                                          },
                              }
                  },
                  -- northern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_North',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    -4*largeeps-eps, 
                                                    4*largeeps+eps, 
                                                    -4*largeeps-eps, 
                                                  },
                                          },
                              }
                  },
                  -- bottom slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_Bottom',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                    -4*largeeps-eps, 
                                                    -4*largeeps-eps, 
                                                    -4*largeeps-eps, 
                                                  },
                                          },
                              }
                  },
                  -- top slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_Top',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                    -4*largeeps-eps, 
                                                    -4*largeeps-eps, 
                                                    4*largeeps+eps, 
                                                  },
                                          },
                              }
                  },
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'euler',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {4*largeeps-2*eps,0.0,0.0},
                                                  {0.0,4*largeeps-2*eps,0.0},
                                                  {0.0,0.0,4*largeeps-2*eps},
                                                },
                                           origin={
                                                   -2*largeeps+eps,
                                                   -2*largeeps+eps,
                                                   -2*largeeps+eps,
                                                  },
                                          },
                              }
                  },
                }
	    
