#!/bin/bash
#SBATCH --time=2:00:00
#SBATCH --mail-type=END
#SBATCH --mail-user=verena.krupp@uni-siegen.de
#SBATCH --partition=short
#SBATCH -N 1
#SBATCH --job-name=precice
#SBATCH --exclusive
#SBATCH --output=coupled.out
#SBATCH --error=coupled.err


module load openmpi/intel/64/1.4.4
module load intel/13/13.0.1
module load fftw3/intel/64/3.3

date
mpiexec -np 1 /home/gk780/lib/precice/build/debug-nopython/binprecice server Ateles_euler precice_config.xml >server_euler1.out &
mpiexec -np 1 /home/gk780/lib/precice/build/debug-nopython/binprecice server Ateles_acoustic precice_config.xml >server_acoustic1.out &
mpiexec -np 1 /home/gk780/ateles_precice/build/debug/ateles  ateles_euler.lua >euler1.out &
mpiexec -np 1 /home/gk780/ateles_precice/build/debug/ateles  ateles_acoustic.lua >acoustic1.out 
date
