-- Use this file as template. Do not modify this file for running some testcases

outputname = 'plate'
outputpreview = true 
folder = 'mesh_acoustic/'

minlevel = 3

cubeLength = 4.0

--debug = { debugMode = true, debugMesh = 'debug/' }
-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {cubeLength/(-2.0),cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }

-- the level of the slip walls (has to be the same as the min level)
geom_level = minlevel

-- the refinement level of the plate
plate_level = minlevel+4
--plate_level = minlevel

-- smallness parameter
eps = bounding_cube.length/(2^(plate_level+5))

-- the element size around the plate
smalleps = bounding_cube.length/(2^plate_level)

-- the element size of the largest elements (belonging to minlevel)
largeeps = bounding_cube.length/(2^geom_level+1)

spatial_object = 
                {
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {-1.0, -1.0, -1.0},

                                        },
                             },
                  },
                  -- eastern acoustic bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_East',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   -1.5-largeeps, 
                                                   -1.0-largeeps, 
                                                   -1.0-largeeps,
                                                  },
                                          },
                              }
                  },
                  -- western outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_West',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   1.5+largeeps, 
                                                   -1.0-largeeps, 
                                                   -1.0-largeeps,
                                                  },
                                          },
                              }
                  },
                  -- southern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_South',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   -1.5-largeeps, 
                                                   -1.0-largeeps, 
                                                   -1.0-largeeps,
                                                  },
                                          },
                              }
                  },
                  -- northern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_North',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   -1.5-largeeps, 
                                                   1.25+largeeps, 
                                                   -1.0-largeeps,
                                                  },
                                          },
                              }
                  },
                  -- bottom slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_Bottom',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                   -1.5-largeeps, 
                                                   -1.0-largeeps, 
                                                   -1.0-largeeps,
                                                  },
                                          },
                              }
                  },
                  -- top slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_Top',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                   -1.5-largeeps, 
                                                   -1.0-largeeps, 
                                                   1.25+largeeps,
                                                  },
                                          },
                              }
                  },
                  -- eastern inflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'euler',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {3.0+2*largeeps,0.0,0.0},
                                                  {0.0,0.25-2*largeeps,0.0},
                                                  {0.0,0.0,0.25-2*largeeps},
                                                },
                                           origin={
                                                   -1.5+largeeps,
                                                   0.0+largeeps,
                                                   0.0+largeeps,
                                                  --   (-1)*bounding_cube.length/2+largeeps,
                                                  --   (-1)*bounding_cube.length/2+largeeps,
                                                  --   (-1)*bounding_cube.length/2+largeeps,
                                                  },
                                          },
                              }
                  },
                }
	    
