-- Configuration file for Ateles --
commpattern = os.getenv('cpat')
nprocs = os.getenv('nprocs')
level = os.getenv('level')


-- global simulation options
simulation = {
              name          = level .. '_' .. nprocs .. '_' ..  commpattern ,                 -- the name of the simualtion
              final_time    = 
                                  math.min(
                                    10000 * nprocs / math.pow(2, 4*level) ,  
                                    5000 * 0.1 / math.pow(2, level)  --leads approximately to 28000 iterations
                                      )
             }

commpattern = cpat

-- VTK output (this is still a dummy implementation)
--output = { 
--          time      = '0.1',                                         -- time interval for VTK output
--          iteration = '',                                            -- iteration interval for VTK output
--          output_folder = './output/euler/'-- the folder the output is written to 
--         }

-- Mesh definitions --
-- mesh = './'
mesh = { predefined = 'cube',
         origin = {0.0, 0.0, 0.0},
         length = 10.0,
         refinementLevel = level
       }

restart = { ead = 'restart_read/gauss_pulse_euler_lastHeader.lua',
            write = 'restart_read/',
--            time = {useIterations = true,  min = 1 , max = 20, interval = 2}}
            time = {useIterations = false,  min = 100.0 , max = 1000.0, interval = 10000.0}}

-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
          folder = './',                                             -- the folder for the timing results
          filename = 'timing.res'                                    -- the filename of the timing results
         }


-- Equation definitions --
equation = {
    name   = 'euler',
    therm_cond = 2.555e-02,
    isen_coef = 1.4,
    r      = 296.0,
}


-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'muscl',             -- we use the weno scheme for reconstruction
               }, 
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitEuler',    -- we use explicit runge kutta in time
               --steps = 4,                      -- we have a 3 stage 
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.3,     -- CourantFriedrichsLewy number
                         },
               },
}

-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = {predefined='gausspulse',
                                 center={5.0, 5.0, 5.0},
                                 halfwidth=2.0,
                                 amplitude=2.0,
                                 background=1.225},
                      pressure = 100000,
                      velocityX = 10.0,
                      velocityY = 0.0,
                      velocityZ = 0.0}

