-- Use this file as template. Do not modify this file for running some testcases

outputname = 'mesh'
outputpreview = true 
folder = 'mesh_2d/'

level = 6
maxlevel = level
minlevel = level

cubeLength = 64.0

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {cubeLength/(-2.0),cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }
box_length = 10.0 -- original 60              


-- the element size of the largest elements (belonging to minlevel)
eps = bounding_cube.length/(2^level+1)
elemSize = bounding_cube.length/(2^level)

spatial_object = {
  {
    attribute = {kind = 'seed' },
    geometry = {
      kind   = 'canoND',
      object = {origin = {0.0,0.0,0.0} },
    },
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'outside',
      level = level,
    },
    geometry = {
      kind = 'canoND',
      object = {
        only_surface = true,
        vec= {
          {box_length+2*eps,0.0,0.0},
          {0.0,box_length+2*eps,0.0},
          {0.0,0.0,elemSize+2*eps},
        },
        origin={-box_length/2-eps,-box_length/2-eps, -eps}
      },
    },
  },
}
