## This is an example user-script for plotting performance data using the
## gleaner module.

# Path to gleaner (Better use environment variable PYTHONPATH!)
import matplotlib.pyplot as mplt
import matplotlib.ticker as mtick
import numpy as np
import sys
import os
home = os.getenv('HOME')
sys.path.append(home+'/gleaner')

from matplotlib import rc
rc('text',usetex=True)
font_size = 12
font_family='sans-serif'
font_type='sans-serif'
font = {'family':font_family,'%s'%font_family:font_type,'size':font_size}
rc('font',**font)

#axis without scientific notation
y_formatter = mtick.ScalarFormatter(useOffset=False)

# Import all required modules
import gleaner

import logging

print('Error analysis for monolothic')

logging.basicConfig(level=logging.INFO)
## -------------------------------------------------------------------------- ##
casename = ['navier','euler','lineuler']
# data base filename
dbname = 'timeevolution.db'
# load database if exist else load tracking files and add to database
if os.path.isfile(dbname):
  print ('Processing data from existing database')
#  os.remove(dbname)
  import sqlite3
  sqlcon = sqlite3.connect(dbname)
else:
 for icase in range(len(casename)):
    print ('processing data from '+casename[icase])
    sqlcon = gleaner.tracking_to_db(fname = [casename[icase]+'/track_pulse/ateles_pre_west_p00000.res'], \
                                    dbname=dbname, tabname='pre_'+casename[icase])
    sqlcon = gleaner.tracking_to_db(fname = [casename[icase]+'/track_pulse/ateles_post_west_p00000.res'], \
                                    dbname=dbname, tabname='post_'+casename[icase])

print ('Ploting ')
fig = mplt.figure()
ax = fig.add_subplot(111)

get_data_for_cols = ['time','pressure','ref_pressure', 'error']
[time, ns_pre_press, ns_pre_ref_press, ns_pre_error ] = gleaner.get_columns(sqlcon, \
                                                                            tabname='pre_ns', \
                                                                            columns=get_data_for_cols )
get_data_for_cols = ['time','pressure','ref_pressure', 'error']
[time, ns_post_press, ns_post_ref_press, ns_post_error ] = gleaner.get_columns(sqlcon, \
                                                                            tabname='post_ns', \
                                                                            columns=get_data_for_cols )
mplt.plot(time, ns_pre_ref_press, ls = '-', color = 'k', lw = 2.0, label = 'analytical')
mplt.plot(time, ns_pre_press, ls = '--', color = 'r', lw = 2.0, label = 'navier pre')
mplt.plot(time, ns_pre_press, ls = '--', color = 'b', lw = 2.0, label = 'navier post')

get_data_for_cols = ['time','pressure','ref_pressure', 'error']
[time, ns_pre_press, ns_pre_ref_press, ns_pre_error ] = gleaner.get_columns(sqlcon, \
                                                                            tabname='pre_ns', \
                                                                            columns=get_data_for_cols )
get_data_for_cols = ['time','pressure','ref_pressure', 'error']
[time, ns_post_press, ns_post_ref_press, ns_post_error ] = gleaner.get_columns(sqlcon, \
                                                                            tabname='post_ns', \
                                                                            columns=get_data_for_cols )
mplt.plot(time, ns_pre_ref_press, ls = '-', color = 'k', lw = 2.0, label = 'analytical')
mplt.plot(time, ns_pre_press, ls = '--', color = 'r', lw = 2.0, label = 'navier pre')
mplt.plot(time, ns_pre_press, ls = '--', color = 'b', lw = 2.0, label = 'navier post')
                
mplt.legend(loc=1, ncol=1,borderaxespad=0, \
            prop={'size':font_size}).get_frame().set_lw(0.0)
mplt.xlabel('Time (s)')
mplt.ylabel('Pressure')
mplt.grid(True,which="major",ls="-")
ax.yaxis.set_major_formatter(y_formatter)
#  mplt.xlim(0.4, 0.6)
#  mplt.ylim(1.53, 1.9)
  
# save fig
figsize = [8,6]
fig = mplt.gcf()
fig.set_size_inches(figsize[0],figsize[1])
mplt.savefig('timeevolution_west.pdf', dpi=100, format='pdf', \
               bbox_inches="tight",interpolation=None)
