require 'common'

-- simulation controll parameter-----------------------------------------------
timing_file = 'timing.res'
simulation_name='ateles' 

sim_control = {
  time_control = {
    min = 0,
    max = { sim =tmax, iter = 3},
    interval = {iter = 100}, -- final simulation time
  }
}

-- Restart -------------------------------------------------------------------
restart = {
  write = 'restart/',
  time_control = {
    min = 0,
    max = tmax,
    interval = {iter=1}, -- final simulation time
  },
}

-- Tracking
segments = 60*(degree+1)
NOtracking = {
  -- Line tracking
  {
    label = 'lineX_pressure',
    folder = './track_pulse/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        origin   = { -30.0, 0.0, 0.0 },
        vec      = { 60.0, 0.0 ,0.0},
        segments = { segments},
      },
    },
    time_control = {min = 0, max = tmax, interval = line_track_dt},
    output = { format = 'asciiSpatial', use_get_point = true},
  },
  {
    label = 'lineY_pressure',
    folder = './track_pulse/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        origin   = { 0.0, -30.0, 0.0 },
        vec      = { 0.0, 60.0 ,0.0},
        segments = { segments},
      },
    },
    time_control = {min = 0, max = tmax, interval = line_track_dt },
    output = { format = 'asciiSpatial', use_get_point = true},
  },
  {
    label = 'lineZ_pressure',
    folder = './track_pulse/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        origin   = { 0.0, 0.0, -30.0 },
        vec      = { 0.0, 0.0 ,60.0},
        segments = { segments},
      },
    },
    time_control = {min = 0, max = tmax, interval = line_track_dt},
    output = { format = 'asciiSpatial', use_get_point = true},
  },
  {
    label = 'center',
    folder = './track_pulse/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        { origin = { 0.0, 0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval = {iter=1}},
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'pre_west',
    folder = './track_pulse/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point west 
        { origin = { -9.99,0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'post_west',
    folder = './track_pulse/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point west 
        { origin = { -10.01, 0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
}

bg_dens = dens
bg_velX = velX
bg_velY = velY
bg_velZ = velZ
bg_press = press

variable = {
  {
    name = 'bg_density',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun =  bg_dens,  
  },
  {
    name = 'bg_velocity',
    ncomponents = 3,
    vartype = 'st_fun',
    st_fun =  {bg_velX, bg_velY, bg_velZ}  
  },
  {
    name = 'bg_pressure',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun =  bg_press,  
  },
   -- get full states
  {
    name = 'full_density',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'addition',
      input_varname = {'density','bg_density'},
    }          
  },
  {
    name = 'full_velocity',
    ncomponents = 3,
    vartype = 'operation',
    operation = {
      kind = 'addition',
      input_varname = {'velocity','bg_velocity'},
    }          
  },
  {
     name = 'full_pressure',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'addition',
       input_varname = {'pressure','bg_pressure'},
     }          
  },
  {
     name = 'ref_pressure',
     ncomponents = 1,
     vartype ='st_fun',
     st_fun = { 
       predefined = 'acoustic_pulse',
       center     = gp_center,
       halfwidth  = gp_halfwidth,
       amplitude  = gp_amplitude,
       background = gp_background,
       speed_of_sound = gp_c,
     }
  },
  {
     name = 'error',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'difference',
       input_varname = {'pressure', 'ref_pressure'},
    }
  },
}

-- Mesh definitions --
mesh = 'mesh/'

-- Scheme definitions --
scheme = {
  -- the spatial discretization scheme
  spatial =  {
    name = 'modg',
    modg_space = 'Q',
    m = degree,
  },
  -- the temporal discretization scheme
  temporal = {
    name = 'explicitSSPRungeKutta',
    steps = 2,
    control = {
      name = 'cfl',
      cfl = 0.9,
    },
  },
}

-- Equation definitions --
equation = {
  name = 'LinearEuler',
  therm_cond = 2.555e-02,
  isen_coef = 1.4,
  background = {
    density =  bg_dens,
    velocityX = bg_velX,
    velocityY = bg_velY,
    velocityZ = bg_velZ,
    pressure = bg_press
  }
}

-- initial condition --
initial_condition = {
  density = 0.0,
  velocityX = 0.0,
  velocityY = 0.0,
  velocityZ = 0.0,
  pressure = { 
    predefined = 'gausspulse',
    center     = gp_center,
    halfwidth  = gp_halfwidth,
    amplitude  = gp_amplitude,
    background = gp_background,
  },
}

 -- Boundary definitions
boundary_condition = {
  {
    label = 'outside',
    kind = 'primitives',
    density = 0.0, 
    velocityX = 0.0,
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = 0.0,
  }
}
