-- Use this file as template. Do not modify this file for running some testcases

outputname = 'shock_vort'
outputpreview = true 


-- fix minimum level to 2
minlevel = 2

-- global background refinement level
refinelevel = 3

-- the refinement level around the vortex
vortexrefinelevel = 6

cubeLength = 20.0

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {cubeLength/(-2.0),cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }

largeeps = cubeLength/math.pow(2,minlevel)
smalleps = cubeLength/math.pow(2,refinelevel)

eps = 1e-6

spatial_object = 
                {
                  -- eastern inflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'inflow',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                     (-1)*largeeps-eps ,
                                                     (-1)*bounding_cube.length/2+eps,
                                                     (-1)*bounding_cube.length/2+eps,
                                                  },
                                          },
                              }
                  },
                  -- western outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'outflow',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   largeeps+eps, 
                                                   -bounding_cube.length/2+eps, 
                                                   -bounding_cube.length/2+eps, 
                                                  },
                                          },
                              }
                  },
                  -- southern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipSouth',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    -largeeps-eps,
                                                    -bounding_cube.length/2+eps
                                                  },
                                          },
                              }
                  },
                  -- northern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipNorth',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    largeeps+eps,
                                                    -bounding_cube.length/2+eps
                                                  },
                                          },
                              }
                  },
                  -- bottom slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipBottom',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    -bounding_cube.length/2+eps,
                                                    -largeeps-eps
                                                  },
                                          },
                              }
                  },
                  -- top slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipTop',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    -bounding_cube.length/2+eps,
                                                    largeeps+eps
                                                  },
                                          },
                              }
                  },
                  -- global, background refinement box
                  {
                   attribute = {
                                 kind = 'refinement',
                                 level = refinelevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {2*(largeeps-eps),0.0,0.0},
                                                  {0.0,2*(largeeps-eps),0.0},
                                                  {0.0,0.0,2*(largeeps-eps)},
                                                },
                                           origin={
                                                    -largeeps+eps,
                                                    -largeeps+eps,
                                                    -largeeps+eps,
                                                  },
                                          },
                              }
                  },
                  -- refinement box around the vortex
                  {
                   attribute = {
                                 kind = 'refinement',
                                 level = vortexrefinelevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {2.6,0.0,0.0},
                                                  {0.0,2.6,0.0},
                                                  {0.0,0.0,2.6},
                                                },
                                           origin={
                                                    -1.3,
                                                    -1.3,
                                                    -1.3,
                                                  },
                                          },
                              }
                  },
                  -- seed 
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {0,0,0},

                                        },
                             },
                  },
                }
	    
