require('common_2d')

-- Equation definitions --
equation = {
    -- Physical parameters of the gas phase
    name   = 'euler_2d',
    isen_coef = isen_coef,
    r      = r,
    -- Parameters of the penalization
    porosity             = 1,
    viscous_permeability = 1,
    thermal_permeability = 1,
    -- The definition of an obstacle by penalization
    penalization = {
                     global = {
                                kind = 'const',
                                const = {0.0, 0.0, 0.0, 0.0},
                              },
                   }, 
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)


