-- global simulation options
simulation_name = 'euler_3d'
sim_control = {
                time_control = {   
                                min = 0, 
                                max = { iter = 1}, 
                               }
              }
check = {
          interval = 1,
        }

characteristic = 0.0
function relax_velocity(x,y,z,t)
  return {0.0, 0.0, 0.0}
end
relax_temperature = 0.0
variable = {
  -- This is the global material for Euler 3D. It consists of three different 
  -- components, characteristics with one scalar, relax_velocity with three 
  -- scalars and relax_temperature with one scalar, thus we need five scalars
  -- for this equation system.
  -- As this is the global fallback material, we define each material to be a 
  -- neutral term, which in this case is 0.
  {
     name = 'characteristic',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = characteristic
  },
  {
     name = 'relax_velocity',
     ncomponents = 3,
     vartype = "st_fun",
     st_fun = relax_velocity
  },
  {
     name = 'relax_temperature',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_temperature
  }
}

-- Mesh definitions --
mesh = './mesh/'

-- Equation definitions --
equation = {
    name   = 'euler',
    therm_cond = 2.555e-02,
    isen_coef = 1.4,
    r      = 296.0,
    material = {
                 characteristic = 'characteristic',
                 relax_velocity = 'relax_velocity',
                 relax_temperature = 'relax_temperature'
               }
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)


-- The state right of the shock
rho_r = 1.0
u_r = 0.0
p_r = 1.0
mach_r = u_r/math.sqrt( equation.isen_coef * p_r / rho_r )

-- Shock properties
shockMach = 2.0
shockXCoord = -1.2
shockSpeed = shockMach * math.sqrt(equation.isen_coef * p_r / rho_r )

-- The state left of the shock (evaluated by Rankine-Huginoit condition)
chi = ( u_r - shockSpeed ) / math.sqrt(equation.isen_coef * p_r / rho_r )
rho_l = rho_r * ( ((equation.isen_coef+1)*chi*chi) / ((equation.isen_coef-1)*chi*chi+2) )  
u_l = shockSpeed + ( u_r - shockSpeed ) * (rho_r/rho_l) 
p_l = p_r * ( (2*equation.isen_coef*chi*chi-(equation.isen_coef-1)) / (equation.isen_coef+1) ) 
mach_l = u_l/math.sqrt( equation.isen_coef * p_l / rho_l )

print('Mach number relevant for inflow: ', mach_l)
print('Mach number relevant for outflow: ', mach_r)

function rho(x,y,z)
    --if( z < 1/3.0 ) then
    --    return rho_l
    --else
    --    return rho_r
    --end
    return rho_r + z
end

function p(x,y,z)
    --if( z < 1/3.0 ) then
    --    return p_l
    --else
    --    return p_r
    --end
    return p_r
end

function u(x,y,z)
    --if( z < 1/3.0 ) then
    --    return u_l
    --else
    --    return u_r
    --end
    return u_r
end

projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattoPoints = false  -- if lobatto points should be used, default = false
              factor = 2.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
              blocksize = 32,        -- for fpt, default -1
           -- fftMultiThread = false -- for fpt, logical, default false
             }

initial_condition = { 
                      density = rho,
                      pressure = p,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = u,
             }

-- Scheme definitions --
filter_order = 14
scheme = {
           -- the spatial discretization scheme
           spatial =  {
                        name = 'modg',             
                        m = 4,
                      }, 
           ---- the stabilzation of the scheme
           stabilization = {
                             {
                              name = 'spectral_viscosity',
                              alpha = 36,
                              order = filter_order,
                             },
                             {
                              name = 'covolume',
                              alpha = 36,
                              order = filter_order,
                              beta = 1.0,
                             },
                           },
           -- temporal discretization
           temporal ={
                      name = 'explicitSSPRungeKutta',  
                      steps = 2,
                      control = {
                                 name = 'cfl',   
                                 cfl  = 0.3,
                                },
                     }
}

epsx = 1e-3
tracking = {
  label = 'probe_density_Q4_periodic_covolume_z',
  folder = './',
  variable = {'density'},
  shape = {
    kind = 'canoND',
    object= {
      origin = { (1/2) + epsx, (1/2) + epsx, (1/2) + epsx }
    }
  },
  time_control = {
    min = 0, 
    max = sim_control.time_control.max, 
    interval = sim_control.time_control.max
  },
  output = { format = 'ascii', ndofs = 1 }, -- 'asciiSpatial', 'harvester', 'convergence'
}
--restart = {
--           write = './restart/',
--           time_control = {   
--                            min = 0.0, 
--                            max = sim_control.time_control.max,
--                            interval = sim_control.time_control.max,
--                          }
--          }
