simulation_name = 'shear_tube'

mesh = {
    predefined = 'cube',
    refinementLevel = 3,
    length = 0.125,
    origin = {0.0, -0.0625, -0.0625}
}

sim_control = {
    time_control = {
        min = 0,
        max = {iter = 100},
        interval = {iter = 1},
        check_iter = 1
    }
}

-- EQUATION --
equation = {
  name       = 'navier_stokes',
  isen_coef  = 1.4,
  r          = 296,
  therm_cond = 5.92e-3,
  mu         = 4e-6, 
  ip_param   = 4, 
  material = {
    characteristic = 0.0,
    relax_velocity = {0.0, 0.0, 0.0},
    relax_temperature = 1.0
  }
}
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)
--
--


-- SCHEME --
scheme = {
    spatial = {
        name = 'modg',
        m    = 1
    },
    temporal = {
        name = 'explicitSSPRungeKutta',
        steps = 2,
        control = {
            name = 'fixed',
            dt = 2.5e-4
        }
    },
    stabilization = {
        name = 'cons_positivity_preserv',
        eps  = 1.0e-8
    }
}

projection = {
  kind = 'fpt',
  factor = 3.0,
  lobattoPoints = true
}
--
--


-- Description of the medium
press = 1
dens = 1.4
mach = 0.8


-- Description of the Jet-Tube
jet_radius = mesh.length * 2^(-mesh.refinementLevel)
velAmpl = mach*math.sqrt(equation.isen_coef*press/dens)

velX = function(x,y,z)
  if (math.abs(y) < jet_radius and math.abs(z) < jet_radius) then
    return velAmpl
  else
    return 0.0
  end
end

-- INITIAL CONDITION --
initial_condition = { 
  density = dens,
  pressure = press,
  velocityX = velX,
  velocityY = 0.0,
  velocityZ = 0.0,
}
--
--

restart = {
    write = 'restart/',
    read = 'restart/shear_tube_lastHeader.lua',
    init_on_missing = true,
    time_control = sim_control.time_control
}
