-- Configuration file for Ateles --
require 'hyperfun'


-- ...the length of the cube
cubeLength = 2.0


-- global simulation options
simulation = {
              name          = 'shear_layer_modg',                -- the name of the simualtion
              time    =  {
                           useIterations = false,
                           min = 0.0,
                           max = 1.0e-05,
                         }
             }


-- Mesh definitions --
mesh = './mesh/'


-- Restart settings
restart = { 
            write = './restart/',                                        
            time = {   
                      useIterations = false,  
                      min = 0, 
                      max = simulation.time.max,
                      interval = simulation.time.max/2.0,
                   },  
          }

-- Tracking              
tracking = { 
             label = 'probe_momentum_Q4_l2p6',
             folder = './',
             variable = {'momentum'}, 
             shape = {kind = 'canoND', object= { origin ={0., 0., 0.} } },
             time = {
                      useIterations = false,  
                      min = 0, 
                      max = simulation.time.max, 
                      interval = simulation.time.max/2.0,
                    },  
             format = 'ascii' 
 }

-- the filename of the timing results i.e. output for performance measurements
timing_file = 'timing.res'        

-- Equation definitions --
equation = {
    name   = 'euler',
    therm_cond = 2.555e-02,
    isen_coef = 1.4,
    r      = 296.0,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg',            -- we use the modal discontinuous Galerkin scheme 
               m =  3,                   -- the maximal polynomial degree for each spatial direction
           --    dealiasFactor = 1.0,      -- factor to remove aliases: 1.0 means no additional dealiasing
           --    blocksize = 32,
               }, 
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitRungeKutta',  --'explicitEuler',
               steps = 4,
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.6 ,  -- CourantÐFriedrichsÐLewy number
                         },
               },
}

width = 0.07
xDist = 0.1
vel =  50.0
periods=2
function iniVelX(x,y,z)
  center = math.sin(periods*math.pi*x)*xDist
  return vel*tanh((y-center)/width)
end

projection = {
              kind = 'l2p',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattoPoints = false  -- if lobatto points should be used, default = false
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
              blocksize = 32,        -- for fpt, default -1
           -- fftMultiThread = false -- for fpt, logical, default false
             }


-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = 1.225,
                      pressure = 100000,
                      velocityX = iniVelX,
                      velocityY = 0.0,
                      velocityZ = 0.0, 
               --       projOverSampling =  1,
               --       useFpt = true,
                    }

-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'slipSouth', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipNorth', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipTop', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipBottom', 
                       kind = 'slipwall',       
                       }
                       ,
                     }  
