-- Use this file as template. Do not modify this file for running some testcases

outputname = 'mesh_2d_riemann'
outputpreview = true 

-- ATTENTION: the minimum is 3, otherwise you won't get any fluid element.
minlevel = 8

cubeLength = 4.0

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {cubeLength/(-2.0),cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }


eps = bounding_cube.length/2^(minlevel+3)
elemSize = bounding_cube.length/2^(minlevel)
spatial_object = 
                {
                  -- western slip bnd (Quadrant II)
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipWest_QuadII',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,0.5-2*eps,0.0},
                                                  {0.0,0.0,2.0},
                                                },
                                           origin={0.0-eps,0.5+eps,-1.0+eps},
                                          },
                              }
                  },
                  -- western slip bnd (Quadrant III)
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipWest_QuadIII',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,0.5-2*eps,0.0},
                                                  {0.0,0.0,2.0},
                                                },
                                           origin={0.0-eps,0.0+eps,-1.0+eps},
                                          },
                              }
                  },
                  -- eastern slip bnd (Quadrant I)
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipEast_QuadI',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,0.5-2*eps,0.0},
                                                  {0.0,0.0,2.0},
                                                },
                                           origin={1.0+eps,0.5+eps,-1.0+eps},
                                          },
                              }
                  },
                  -- eastern slip bnd (Quad IV)
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipEast_QuadIV',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,0.5-2*eps,0.0},
                                                  {0.0,0.0,2.0},
                                                },
                                           origin={1.0+eps,0.0+eps,-1.0+eps},
                                          },
                              }
                  },
                  -- southern slip bnd (Quadrant III)
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipSouth_QuadIII',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.5-2*eps,0.0,0.0},
                                                  {0.0,0.0,2.0},
                                                },
                                           origin={0.0+eps,0.0-eps,-1.0+eps},
                                          },
                              }
                  },
                  -- southern slip bnd (Quadrant IV)
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipSouth_QuadIV',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.5-2*eps,0.0,0.0},
                                                  {0.0,0.0,2.0},
                                                },
                                           origin={0.5+eps,0.0-eps,-1.0+eps},
                                          },
                              }
                  },
                  -- northern slip bnd (Quadrant II)
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipNorth_QuadII',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.5-2*eps,0.0,0.0},
                                                  {0.0,0.0,2.0},
                                                },
                                           origin={0.0+eps,1.0+eps,-1.0+eps},
                                          },
                              }
                  },
                  -- northern slip bnd (Quadrant I)
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipNorth_QuadI',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.5-2*eps,0.0,0.0},
                                                  {0.0,0.0,2.0},
                                                },
                                           origin={0.5+eps,1.0+eps,-1.0+eps},
                                          },
                              }
                  },
                  -- bottom slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipBottom',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {2.0,0.0,0.0},
                                                  {0.0,2.0,0.0},
                                                },
                                           origin={-1.0+eps,-1.0+eps,-eps},
                                          },
                              }
                  },
                  -- top slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipTop',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {2.0,0.0,0.0},
                                                  {0.0,2.0,0.0},
                                                },
                                           origin={-1.0+eps,-1.0+eps,elemSize+eps},
                                          },
                              }
                  },
                  -- seed 
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {0.5,0.5,0.0 },
                                        },
                             },
                  },
                }
	    
