-- Configuration 2

require('quadrant')

-- Filter order for the Covolume stabilization and spectral viscosity
filter_order = 10

final_sim_time = 0.2

-- Initial condition for density
function ini_dens(x,y,z)
  -- get the quadrant
  quad = get_quadrant(x,y)

  if(quad == 1) then
    return 1.0
  elseif(quad == 2) then
    return 0.5197
  elseif(quad == 3) then
    return 1.0
  else
    return 0.5197
  end
end

-- Initial condition for pressure
function ini_press(x,y,z)
  -- get the quadrant
  quad = get_quadrant(x,y)

  if(quad == 1) then
    return 1
  elseif(quad == 2) then
    return 0.4
  elseif(quad == 3) then
    return 1
  else
    return 0.4
  end
end

-- Initial condition for velocity (x-component)
function ini_vel_X(x,y,z)
  -- get the quadrant
  quad = get_quadrant(x,y)

  if(quad == 1) then
    return 0
  elseif(quad == 2) then
    return -0.7259 
  elseif(quad == 3) then
    return -0.7259 
  else
    return 0.0
  end
end


-- Initial condition for velocity (y-component)
function ini_vel_Y(x,y,z)
  -- get the quadrant
  quad = get_quadrant(x,y)

  if(quad == 1) then
    return 0.0
  elseif(quad == 2) then
    return 0.0
  elseif(quad == 3) then
    return -0.7259
  else
    return -0.7259
  end
end

-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'slipWest_QuadII', 
                       kind = 'outflow',       
                       pressure = ini_press,
                       },
                       { 
                       label = 'slipWest_QuadIII', 
                       --kind = 'outflow',       
                       --pressure = ini_press,
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipEast_QuadI', 
                       kind = 'slipwall',       
                       },
                       { 
                       label = 'slipEast_QuadIV', 
                       kind = 'slipwall',       
                       },
                       { 
                       label = 'slipSouth_QuadIII', 
                       --kind = 'outflow',       
                       --pressure = ini_press,
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipSouth_QuadIV', 
                       kind = 'outflow',       
                       pressure = ini_press,
                       },
                       { 
                       label = 'slipNorth_QuadII', 
                       kind = 'slipwall',       
                       },
                       { 
                       label = 'slipNorth_QuadI', 
                       kind = 'slipwall',       
                       },
                       { 
                       label = 'slipBottom', 
                       kind = 'slipwall',       
                       },
                       { 
                       label = 'slipTop', 
                       kind = 'slipwall',       
                       },
                     }  
