-- Configuration file for Ateles --


-- ...the length of the cube
cubeLength = 2.0*math.pi

-- the refinement level of the octree
level = 4

-- global simulation options
sim_name = 'tgv_nvrstk_modg_2d'
logging = {level=10}
sim_control = {
                time_control = {   
                                 max =  {iter = 1000000},
                               }
             }

check = {
          interval = 1,
        }


-- Mesh definitions --
mesh = { predefined = 'slice',
         origin = { 
                    0.0,
                    0.0,
                    0.0,
                  },
         length = cubeLength,
         refinementLevel = level
       }


characteristic = 0.0
--function relax_velocity(x,y,z,t)
--  return {0.0,0.0}
--end
relax_temperature = 0.0



variable = {
  -- This is the global material for Euler 2D. It consists of three different 
  -- components, characteristics with one scalar, relax_velocity with two 
  -- scalars and relax_temperature with one scalar, thus we need four scalars
  -- for this equation system.
  -- As this is the global fallback material, we define each material to be a 
  -- neutral term, which in this case is 0.

  {  
     name = 'characteristic',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = characteristic

  },
  
  {  
     name = 'relax_velocity',
     ncomponents = 2,
     vartype = "st_fun",
     st_fun = {const = {0.0,0.0}}

  },
  
  {  
     name = 'relax_temperature',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_temperature

  },
  
}


-- Tracking
Notracking = {
             label = 'track_momentum',
             folder = './',
             variable = {'density', 'momentum', 'energy', 'k', 'omega', 'pressure'},--,{'pressure'}, {'k'}, {'omega'}},
             shape = {kind = 'canoND', object= { origin ={1e-5, 1e-5, 1e-5} } },
             time_control = {
                              min      = { iter = 0},
                              max      = { sim_control.time_control.max.iter },
                              interval = { iter = 1 },
                            },
             output = { format = 'ascii' }, -- 'asciiSpatial', 'harvester', 'convergence'
           }


Norestart = {
             write = './restart/',
             time_control = {
                              min      = { iter = 0},
                              max      = { sim_control.time_control.max.iter },
                              interval = { iter = 1 },
                            },
           }

-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
          folder = './',                  -- the folder for the timing results
          filename = 'timing.res'         -- the filename of the timing results
         }

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
                 name = 'modg_2d',     
                 m = 3,                
               }, 
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitRungeKutta',
               steps = 4,
               --name = 'explicitEuler',
               control = {
                          name      = 'cfl',   
                          cfl       = 0.2, 
                          cfl_visc  = 0.2, 
                         },
               },
}

-- Equation definitions --
-- ... the smallness parameter of the penalization
penalization_eps = 8.0/(scheme.spatial.m+1)
penalization_alpha = 1.0
equation = {
    penalization = {
                     global = {
                                kind = 'const',
                                const = {0.0, 0.0, 0.0, 0.0},
                              },
                   }, 
    name       = 'filtered_navier_stokes_2d',
    turbulence_model = 'rans_2d',
    -- general fluid's parameter
    isen_coef  = 1.4,
    r          = 280.0,
    -- viscous parameters
    --therm_cond = 0.02, 
    therm_cond = 0.5, 
    --mu         = 2.0e-5,  
    mu         = 2.0,  
    ip_param   = 4.0, -- The stabilization parameter for the Interior Penalty discretization
    -- Parameters of the penalization
   -- porosity             = penalization_eps,
   -- viscous_permeability = penalization_alpha*penalization_eps,
   -- thermal_permeability = penalization_alpha*penalization_eps,
    material = {
                 characteristic = 'characteristic',
                 relax_velocity = 'relax_velocity',
                 relax_temperature = 'relax_temperature'

               }
}
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)


projection = {
              kind = 'fpt',
              factor = 1.0,
             }

function ini_dens(x,y,z)
  return 4.0
end 
function ini_vel_x(x,y,z)
  return math.sin(x)*math.cos(y)
end 
function ini_vel_y(x,y,z)
  return math.cos(x) * math.sin(y)
end 
function ini_press(x,y,z)
  return (1.0/4.0)*(math.cos(2.0*x)+math.cos(2.0*y)) + 8.0
end


-- Now, define the initial conditions
initial_condition = { density = ini_dens,
                      pressure = ini_press, 
                      velocityX = ini_vel_x,
                      velocityY = ini_vel_y,
                      k = 0.0,
                      omega = 1.0,
                      useFpt = true, 
                    }

