-- The bounding box length
domain_fac = 1
cubeLength = domain_fac*40.0

-- ... the last 2 digits of the profile number (e.g. 12 for NACA0012)
profile = 45

airfoil_length = 1/(3.0/2/2)
airfoil_height = airfoil_length * profile/100.0

originX = cubeLength/(-2.0)
originY = originX

-- The simulation domain
bounding_cube = {
                 origin = {originX,originY,cubeLength/(-2.0)},
                 length = cubeLength
                }

outputname = 'naca0012'
folder = 'mesh/'

-- the background level
minlevel = 5 + (domain_fac-1)
-- the refinement for the region between foil and outlet
refinelevel = minlevel+1
-- the region around the airfoil
refinelevel_foil = minlevel+1

-- smallness parameter
eps = bounding_cube.length/(2^(refinelevel+5))

-- the size of an element
elemsize = bounding_cube.length/(2^(minlevel))

spatial_object = 
                {
                  -- periodic boundary in z direction
                  {
                    attribute = {
                                 kind = 'periodic',
                                 level = minlevel,
                                },
                    geometry = {
                                 kind = 'periodic',
                                 object = { 
                                            plane1={
                                                      vec= {
                                                             {0.0,bounding_cube.length,0.0},
                                                             {bounding_cube.length,0.0,0.0},
                                                           },
                                                      origin={
                                                               originX+eps,
                                                               originY+eps,
                                                               -eps,
                                                             },
                                                   },
                                            plane2={
                                                      vec= {
                                                             {bounding_cube.length,0.0,0.0},
                                                             {0.0,bounding_cube.length,0.0},
                                                           },
                                                      origin={
                                                               originX+eps,
                                                               originY+eps,
                                                               elemsize+eps,
                                                             },
                                                   },
                                          },
                               },
                  },
                  -- seed 
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {0,-eps,0},

                                        },
                             },
                  },
                  -- west boundary
                  {
                     attribute = {
                                   kind = 'boundary',
                                   label = 'west',
                                   level = minlevel,
                                 },
                     geometry = {
                                   kind = 'canoND',
                                   object = 
                                            {
                                             vec= {
                                                    {0.0,cubeLength,0.0},
                                                    {0.0,0.0,cubeLength},
                                                  },
                                             origin={-(cubeLength/4.0)-eps,-cubeLength/2.0,-cubeLength/2.0},
                                            },
                                },
                  },
                  -- east boundary
                  {
                     attribute = {
                                   kind = 'boundary',
                                   label = 'east',
                                   level = minlevel,
                                 },
                     geometry = {
                                   kind = 'canoND',
                                   object = 
                                            {
                                             vec= {
                                                    {0.0,cubeLength,0.0},
                                                    {0.0,0.0,cubeLength},
                                                  },
                                             origin={(cubeLength/4.0)+eps,-cubeLength/2.0,-cubeLength/2.0},
                                            },
                                },
                  },
                -- north boundary
                {
                    attribute = {
                                  kind = 'boundary',
                                  label = 'south',
                                  level = minlevel,
                                },
                    geometry = {
                                  kind = 'canoND',
                                  object = 
                                           {
                                            vec= {
                                                   {cubeLength,0.0,0.0},
                                                   {0.0,0.0,cubeLength},
                                                 },
                                            origin={-cubeLength/2.0,-(cubeLength/4.0)-eps,-cubeLength/2.0},
                                           },
                               },
                },
                -- south boundary
                {
                    attribute = {
                                  kind = 'boundary',
                                  label = 'north',
                                  level = minlevel,
                                },
                    geometry = {
                                  kind = 'canoND',
                                  object = 
                                           {
                                            vec= {
                                                   {cubeLength,0.0,0.0},
                                                   {0.0,0.0,cubeLength},
                                                 },
                                            origin={-cubeLength/2.0,(cubeLength/4.0)+eps,-cubeLength/2.0},
                                           },
                               },
                },
                 -- refine box from foil to outlet
                 {
                     attribute = {
                                   kind = 'refinement',
                                   level = refinelevel,
                                 },
                     geometry = {
                                   kind = 'canoND',
                                   object = 
                                            {
                                             vec= {
                                                    {cubeLength,0.0,0.0},
                                                    {0.0,2*eps,0.0},
                                                    {0.0,0.0,cubeLength},
                                                  },
                                             origin={-eps,-eps,-cubeLength/2.0},
                                            },
                                },
                 },
                 -- refine box at center
                 {
                     attribute = {
                                   kind = 'refinement',
                                   level = refinelevel_foil,
                                 },
                     geometry = {
                                   kind = 'canoND',
                                   object = 
                                            {
                                             vec= {
                                                    {airfoil_length-2*eps,0.0,0.0},
                                                    {0.0,airfoil_height-2*eps,0.0},
                                                    {0.0,0.0,elemsize-2*eps},
                                                  },
                                             origin={-airfoil_length/2+eps,-airfoil_height/2+eps,eps},
                                            },
                                },
                 },
                }


