-- Configuration file for Ateles --
require('seeder')
require('common_2d')

-- Equation definitions --
equation = {
    name   = 'euler_2d',                 
    -- The definition of an obstacle by penalization
    penalization = {
                     {
                        kind = 'lua_fun',
                        fun = obstacle_function,
                        shape={ 
                                  kind = 'canoND', 
                                  object = {
                                             origin = {
                                                       (-1.0)*scale,
                                                       (-1.0)*scale,
                                                       -eps,
                                                      },
                                             vec = {
                                                      {2.0*scale,0.0,0.0},
                                                      {0.0,2.0*scale,0.0},
                                                      {0.0,0.0,2*elemsize},
                                                   },
                                             segments = {100,100,100},
                                           },
                            },
                     },
                     global = {
                                kind = 'const',
                                const = {0.0, 0.0, 0.0, 0.0},
                              },
                   }, 
    -- Physical parameters of the gas phase
    isen_coef            = isen,
    r                    = boltz,
    -- Parameters of the penalization
    porosity             = penalization_eps,
    viscous_permeability = penalization_alpha*penalization_eps,
    thermal_permeability = penalization_alpha*penalization_eps,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

