-- Use the configuration of the original simulation run.
require 'ateles'

logging = {level = 3}
-- Set the restart data to harvest.
--restart.read = './restart/simulation_lastHeader.lua'
restart.read = '$!file!$'
--restart.read = 'restart_eps1e-1/simulation_header_1.000E+00.lua'


-- Subsampling for tracking, define a ply_sampling table to activate subsampling
-- for all tracking objects (except those with use_get_point).
-- Subsampling (for subresoloved color information):
ply_sampling = { nlevels = 7,    -- maximal level to use in subsampling
                                 -- defaults to 0, which deactivates subsampling
                 --method  = 'fixed' -- method to use for subsampling
                                     -- currently only 'fixed' is implemented,
                                     -- which will refine all elements by
                                     -- nlevels
                                     -- 'fixed' is also the default, thus it
                                     -- is sufficient to only provide nlevels
}

-- Example tracking to generate vtk files:
tracking = {
  { label = 'visu',
    variable = {'density', 'pressure', 'velocity', }, --'mat_characteristic', 'mat_relax_velocity', 'mat_relax_temperature'},
    shape = {kind='global'},
--    time_control = {
--      min = {iter = 0},
--      max = sim_control.time_control.max,
--      interval = sim_control.time_control.max
--    },
--    folder = 'harvest_eps1e-1/',
    folder = '$!out!$',
    --output = {format = 'vtk'}
    output = {format = 'vtk', write_pvd = false}
  }
}
