#/bin/sh
## Set ATELES to point to the Ateles executable!
## And HARVESTER to point to the Harvester executable!

runsim(){
# The spatial order of the MODG scheme
export ATL_ORDER=$1

# Number of elements in the mesh
export ATL_ELEMS=$2

# Dealiasing factor to use in projections:
export ATL_DEALIAS=$3

# Order of the spectral viscosity filter, use 0 to deactivate.
export ATL_FILTER=$4

# Wether to use the covolume filter, unset to deactivate.
if [ -z "$5"]; then
  unset ATL_COVOLUME
else
  export ATL_COVOLUME=$5
fi

${ATELES}
for fd in *_lastHeader.lua; do
  export HVS_INFILE=${fd}
  bn=${fd%_lastHeader.lua}
  export HVS_LABEL=${bn#restart_tube_}
  ${HARVESTER} > /dev/null
  rm ${fd}
done
}

# order, elems, dealias, filter, covolume
# only spectral viscosity runs:
runsim   4 200 1 40
runsim   8 100 1 11
runsim  16  50 1  8
runsim  32  24 1  6
runsim  64  12 1  6
runsim 128   6 1  6
runsim 256   2 1  6

# only covolume runs:
runsim  8 100 1 0 1
runsim 16  50 1 0 1
runsim 32  24 1 0 1
runsim 64  12 1 0 1
