-- Use this file as template. Do not modify this file for running some testcases

folder = 'mesh/'
comment = 'A fully periodic cube with 2 refined cubes inside'

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
cubeLength = 2.0
bounding_cube = {
                  origin = { 
                           (-1.0)*cubeLength/2.0,
                           (-1.0)*cubeLength/2.0,
                           (-1.0)*cubeLength/2.0
                           },
                  length = cubeLength
                }
-- general refinement levels
-- minrefine: defines minimum refinement level of the entire domain
--
-- maxrefine: defines maximum refinement
-- gets overwritten from madatory STL levels
-- (deprecated - used only for spacer stuff right now)
-- will become default for stl refinement level once
-- it is not mandatory any more
minlevel = 3


-- refinebox: three entries: origin, length and refinementlevel
eps = 1e-10
--refinebox = {
--            origin = { 
--                      (-1.0)*cubeLength/4.0+eps,
--                      (-1.0)*cubeLength/4.0+eps,
--                      (-1.0)*cubeLength/4.0+eps
--                     },
--            length = {cubeLength/2.0-2*eps, cubeLength/2.0-2*eps, cubeLength/2.0-2*eps},
--            refinementlevel = minrefine+1
--            }               
spatial_object = {
                   {
                     attribute = { 
                       kind = 'refinement', -- or seed, boundary
                       level = minlevel+1,
                     },

                     geometry = {
                       kind = 'canond',
                       object = {
                                  { 
                                    origin = { 
                                              (-1.0) * cubeLength/4.0+eps,
                                              (-1.0) * cubeLength/4.0+eps,
                                              (-1.0) * cubeLength/4.0+eps,
                                             },
                                    length = cubeLength/2.0 - 2.0*eps
                                  }
                                }
                     }
                   },
                   {
                     attribute = { 
                       kind = 'refinement', -- or seed, boundary
                       level = minlevel+2,
                     },

                     geometry = {
                       kind = 'canond',
                       object = {
                                  { 
                                    origin = { 
                                              (-1.0) * cubeLength/16.0+eps,
                                              (-1.0) * cubeLength/16.0+eps,
                                              (-1.0) * cubeLength/16.0+eps,
                                             },
                                    length = cubeLength/8.0 - 2.0*eps
                                  }
                                }
                     }
                   },
                   {
                      attribute = { kind = 'seed' },
                      geometry = { -- single point definition with a canoND object.
                                   kind = 'canoND',
                                   object = { origin = {0.0, 0.0, 0.0} }
                                 }
                   }
}

