-- Configuration of a Gaussian pulse in a multilevel mesh --
--
-- We expect the mesh to range from -1 to 1 in each dimension
-- with complete periodic boundary conditions all around.

simulation_name = 'ml_pulse'
polydegree = 5

sim_control = {
  time_control = {
     max = 1.0,
     interval = {iter = 1}
  },
  abort_criteria = {
    stop_file = 'stop',
  }
}

mesh = 'mesh/'

equation = {
  name = 'euler',
  numflux = 'lax_friedrich',
  isen_coef = 1.4,
  r = 1.0,
  linear_limit = 0.0,
  linearization_indicator = 'error',
  ensure_positivity = false,
  material = {
    mode_reduction = false,
    characteristic = 0.0,
    relax_velocity = { 0.0, 0.0, 0.0 },
    relax_temperature = 0.0
  }
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

p0 = 1.0
rho0 = p0*equation.isen_coef

-- Restart settings
restart = {
  write = 'restart/',
  time_control = {
    min = 0,
    max = sim_control.time_control.max,
    interval = 0.1,
    align_trigger = true
  }
}

scheme = {
  spatial =  {
    name = 'modg',
    m =  polydegree
  },
  temporal = {
    name = 'explicitRungeKutta',
    steps = 4,
    control = {
      name = 'cfl',
      cfl  = 0.8
    }
  }
}

initial_condition = {
  density = rho0,
  pressure = {
    predefined = 'gausspulse',
    center = {0.0, 0.0, 0.0},
    halfwidth = 0.2,
    amplitude = p0*0.01,
    background = p0
  },
  velocityX = 0.0,
  velocityY = 0.0,
  velocityZ = 0.0
}

projection = {
  kind = 'l2p',
  factor = 1.0
}
