outputname = 'forward_facing_step'

nelemsstep = 2
elemsize = 0.2/nelemsstep

-- The length of the bounding cube (The length is 15 times longer than the steps' height; 
-- ... we need one element for inflow and outlfow (i.e. at least 17 elments); the next
-- ... power of 2 is 32).
length = 32*nelemsstep*elemsize

-- Determine the minimum level which is necessary
minlevel = math.log(length/elemsize)/math.log(2)
print('Minimum level for meshing: ',minlevel)

bounding_cube = {
                 origin = {-1.0, -1.0, -1.0},
                 length = length,
                }

nelemsrefine = 3
refinelevel = minlevel + 5
eps = bounding_cube.length / math.pow(2.0, refinelevel+2)
 
spatial_object = {
                  -- inflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'west',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                     -eps,
                                                     bounding_cube.origin[2]+eps,
                                                     bounding_cube.origin[3]+eps,
                                                  },
                                          },
                              }
                  },
                  -- outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'east',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                     3.0+eps,
                                                     bounding_cube.origin[2]+eps,
                                                     bounding_cube.origin[3]+eps,
                                                  },
                                          },
                              }
                  },
                  -- north slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'north',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                     bounding_cube.origin[1]+eps,
                                                     1.0 + eps,
                                                     bounding_cube.origin[3]+eps,
                                                  },
                                          },
                              }
                  },
                  -- bottom slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'bottom',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                     bounding_cube.origin[1]+eps,
                                                     0.0 - eps,
                                                     bounding_cube.origin[3]+eps,
                                                  },
                                          },
                              }
                  },
                  -- The step
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'step',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,-bounding_cube.length,0.0,},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                     0.6+eps,
                                                     0.2-eps,
                                                     bounding_cube.origin[3]+eps,
                                                  },
                                          },
                              }
                  },
                  -- Refine front of the step
                  {
                   attribute = {
                                 kind = 'refinement',
                                 level = refinelevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,2*elemsize,0.0,},
                                                  {0.0,0.0,elemsize-2*eps},
                                                },
                                           origin={
                                                     0.6-eps,
                                                     eps,
                                                     eps,
                                                  },
                                          },
                              }
                  },
                  -- the refinement around the corner (in downstream direction)
                  {
                   attribute = {
                                 kind = 'refinement',
                                 level = refinelevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {elemsize*nelemsrefine,0.0,0.0},
                                                  {0.0,0.0,elemsize-2*eps},
                                                },
                                           origin={
                                                     0.6+eps,
                                                     0.2+eps,
                                                     eps,
                                                  },
                                          },
                              }
                  },
                  -- periodic boundary in z direction
                  {
                    attribute = {
                                 kind = 'periodic',
                                 level = minlevel,
                                },
                    geometry = {
                                 kind = 'periodic',
                                 object = { 
                                            plane1={
                                                      vec= {
                                                             {0.0,bounding_cube.length,0.0},
                                                             {bounding_cube.length,0.0,0.0},
                                                           },
                                                      origin={
                                                               bounding_cube.origin[1]+eps,
                                                               bounding_cube.origin[2]+eps,
                                                               -eps,
                                                             },
                                                   },
                                            plane2={
                                                      vec= {
                                                             {bounding_cube.length,0.0,0.0},
                                                             {0.0,bounding_cube.length,0.0},
                                                           },
                                                      origin={
                                                               bounding_cube.origin[1]+eps,
                                                               bounding_cube.origin[2]+eps,
                                                               elemsize+eps,
                                                             },
                                                   },
                                          },
                               },
                  },
                  -- the seed
                  {
                    attribute = {
                                  kind = 'seed'
                                },
                    geometry = {
                                 kind = 'canoND',
                                 object =  
                                          {
                                             origin = {0.5,0.5,elemsize/2},
                                          },
                               },
                  },
}
 
