require('common_2d')

-- Equation definitions --
equation = {
    name   = 'navier_stokes_2d',                 
    -- Physical parameters of the gas phase
    isen_coef = 1.4, 
    r      = 296.0,
    -- Physical parameters of the viscous terms
    mu                   = 2*1e-4,
    therm_cond           = 0.0,
    ip_param             = 10.0,
    -- Parameters of the penalization
    porosity             = 1.0, 
    viscous_permeability = 1.0, 
    thermal_permeability = 1.0, 
    penalization = {
                     global = {
                                kind = 'const',
                                const = {0.0, 0.0, 0.0, 0.0},
                              },
                   }, 
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

print('Mach number: ', iniVel/math.sqrt(equation.isen_coef*iniPress/iniDens))
print('Channel-Reynolds number: ', iniVel*0.25*iniDens/equation.mu)
