import matplotlib.pylab as mplab
from matplotlib import pyplot as plt
from matplotlib import animation
import glob
import re
from operator import itemgetter

resfiles = glob.glob('harvest/*.res')

ftimes = []
for rf in resfiles:
  m = re.search('harvest/.*_t(?P<time>.*).res', rf)
  ftimes.append((float(m.group('time')), rf))

sortfiles = sorted(ftimes, key=itemgetter(0))

fig = plt.figure()
ax = plt.axes(xlim=(-1,1), ylim=(0.9,1.5))
ax.set_xticks([-1, -1+(2./6.), -2./6., 0, 2./6., 1-(2./6.), 1])
ax.xaxis.grid(True)
line, = ax.plot([], [], lw=1)

def animate(i):
  state = mplab.loadtxt(sortfiles[i][1])
  line.set_data(state[:,0], state[:,5])
  return line

anim = animation.FuncAnimation(fig, animate, frames=len(sortfiles), interval=40)
anim.save('pressure.mp4', fps=25, bitrate=1000)
plt.show()

#  mplab.plot(state[:,0], state[:,3])
#  mplab.plot(state[:,0], state[:,4])
#  mplab.plot(state[:,0], state[:,5])
#  mplab.show()
