check = {interval = 1, tolerance = 1.0e-10}
order = 30

-- global simulation options
simulation_name = 'euler_1d'
sim_control = { time_control = {max = {iter=20000}}, interval = {iter=1} }

-- Mesh definitions --
mesh = {
     predefined = 'line_bounded',
     origin = {-1.0, -0.2, -0.2},
     length = 2.0,
     element_count = 5
}

characteristic = 0.0
relax_velocity = 0.0
relax_temperature = 0.0

variable = {
  -- This is the global material for Euler 3D. It consists of three different
  -- components, characteristics with one scalar, relax_velocity with three
  -- scalars and relax_temperature with one scalar, thus we need five scalars
  -- for this equation system.
  -- As this is the global fallback material, we define each material to be a
  -- neutral term, which in this case is 0.
  {
     name = 'characteristic',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = characteristic
  },
  {
     name = 'relax_velocity',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_velocity
  },
  {
     name = 'relax_temperature',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_temperature
  },
}
-- Equation definitions --
equation = {
    name   = 'euler_1d',
    isen_coef = 1.4,
    r      = 1.0,
  material = {
    characteristic    = 'characteristic',
    relax_velocity    = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

projection = {
    kind   = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
    factor = 2.0
}

rho = 1.0
p = 1.4
v = 0.0
initial_condition = {
    density  = rho,
    pressure = {
        predefined = 'gausspulse',
        center = {0, 0, 0},
        halfwidth = 0.1,
        amplitude = 0.6,
        background = p
    },
    velocity = v
}

-- Scheme definitions --
scheme = {
    spatial =  {
        name = 'modg_1d',
        m    = order-1,
    },
    temporal = {
        name = 'explicitRungeKutta',
        steps = 4,
        control = { name = 'cfl', cfl  = 0.6 }
    }
}
