check = {interval = 1, tolerance = 1.0e-10}
order = 20

-- global simulation options
simulation_name = 'euler_1d'
sim_control = { time_control = {max = {iter=2000}}, interval = {iter=1} }

-- Mesh definitions --
mesh = {
     predefined = 'line_bounded',
     origin = {-1.0, 0.0, 0.0},
     length = 2.0,
     element_count = 3
}

function characteristic (x,y,z,t)
    return 0.0
end

function relax_velocity(x,y,z,t)
    return {ini_vel_x, ini_vel_y}
end
function relax_temperature (x,y,z,t)
    return 0.0
end

-- equation parameters
penalization_eps = 0.1 --8.0/(scheme.spatial.m+1)
alpha_v = 1e-2
alpha_t = 1e-2
ini_vel_x = 0.0
ini_vel_y = 0.0
ini_dens  = 1.0
ini_press = 1.0
isen  = 1.4
boltz = 1.0
sphere_diameter = 1.0
-- background state
back_press = ini_press/isen                   --equation.background.pressure
back_dens = ini_dens                          --equation.background.density
ini_temp = back_press/back_dens/boltz
c = math.sqrt((isen*back_press)/back_dens)    --speed of sound
Re = 5e5                                      --Reynolds number
Pr = 0.5
viscosity = (back_dens*c*sphere_diameter)/Re  --mu (dynamic viscosity)
cp = boltz*isen/(isen-1) 
th_conductivity = cp*viscosity/Pr
-- Equation definitions --
equation = {
  name      = 'euler_1d',
  isen_coef = 1.4,
  r         = 1.0,
  -- viscous parameters
  therm_cond = th_conductivity, 
  mu         = viscosity,  
  ip_param   = 4.0, -- The stabilization parameter -Interior Penalty discretization
  material  = {
    characteristic    = 'characteristic',
    relax_velocity    = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  },
  porosity             = penalization_eps,
  viscous_permeability = alpha_v*penalization_eps,
  thermal_permeability = alpha_t*penalization_eps,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

projection = {
    kind   = 'l2p',  -- 'fpt' or 'l2p', default 'l2p'
    factor = 1.0
}

rho = 1.0
p = 1.4
v = 0.1
initial_condition = {
    density  = rho,
    pressure = p,
    velocity = v
}

-- Scheme definitions --
scheme = {
    spatial =  {
        name = 'modg_1d',
        m    = order-1,
    },
    temporal = {
        name = 'explicitRungeKutta',
        steps = 4,
        control = { name = 'cfl', cfl  = 0.6 }
    }
}

variable = {
  {
     name = 'characteristic',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = 0.0,
  },

  {
     name = 'relax_velocity',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = 0.0,
  },

  {
    name = 'relax_temperature',
    ncomponents = 1,
    vartype = "st_fun",
    st_fun = 0.0,
  }
}
