folder = 'mesh/'
comment = 'A fully periodic cube with complex refinements'

--debug = { debugMode = true, debugFiles = true, debugMesh = './mesh/debug/' }

minlevel = 2

cubeLength = 2.0
bounding_cube = {
                  origin = { 
                           (-1.0)*cubeLength/2.0,
                           (-1.0)*cubeLength/2.0,
                           (-1.0)*cubeLength/2.0
                           },
                  length = cubeLength
                }



-- refinebox: three entries: origin, length and refinementlevel
-- ... the refinement level of the boxes:
interlevel = minlevel + 2
finelevel = minlevel + 4
elemLengthCoarse = cubeLength/(2^minlevel)
elemLengthInter = cubeLength/(2^interlevel)
elemLengthfine = cubeLength/(2^finelevel)
eps = 1.0e-08
spatial_object = {
                   -- refinement box in the lower left corner (2 level finer than minlevel)
                   {
                     attribute = { 
                       kind = 'refinement', 
                       level = interlevel,
                     },

                     geometry = {
                       kind = 'canond',
                       object = {
                                  { 
                                    origin = { 
                                              (-1.0)*cubeLength/2.0 + eps,
                                              (-1.0)*cubeLength/2.0 + eps,
                                              (-1.0)*cubeLength/2.0 + eps,
                                             },
                                    length = elemLengthCoarse - 2.0*eps
                                  }
                                }
                     }, 
                   },
                   -- refinement box in the lower left corner (4 level finer than minlevel)
                   {
                     attribute = { 
                       kind = 'refinement', 
                       level = finelevel,
                     },

                     geometry = {
                       kind = 'canond',
                       object = {
                                  { 
                                    origin = { 
                                              (-1.0)*cubeLength/2.0 + eps,
                                              (-1.0)*cubeLength/2.0 + eps,
                                              (-1.0)*cubeLength/2.0 + eps,
                                             },
                                    length = elemLengthInter - 2.0*eps
                                  }
                                }
                     }, 
                   },
                   -- refinement box in the center (5 level finer than minlevel)
                   {
                     attribute = { 
                       kind = 'refinement', 
                       level = minlevel+5,
                     },

                     geometry = {
                       kind = 'canond',
                       object = {
                                  { 
                                    origin = { 
                                              0.0,                       
                                              0.0,                       
                                              0.0,                       
                                             },
                                    length = {
                                              elemLengthInter - 2.0*eps,
                                              elemLengthInter - 2.0*eps,
                                              elemLengthInter - 2.0*eps,
                                             },
                                  }
                                }
                     }, 
                   },
                   -- refinement box in the center which cuts both other refinement boxes
                   {
                     attribute = { 
                       kind = 'refinement', 
                       level = minlevel+3,
                     },

                     geometry = {
                       kind = 'canond',
                       object = {
                                  { 
                                    origin = { 
                                              (-1.0)*cubeLength/2.0 + elemLengthCoarse - eps,
                                              (-1.0)*cubeLength/2.0 + elemLengthCoarse - eps,
                                              (-1.0)*cubeLength/2.0 + elemLengthCoarse - eps,
                                             },
                                    length = elemLengthCoarse ,
                                  }
                                }
                     }, 
                   },
                   
                   -- the seed
                   {
                      attribute = { kind = 'seed' },
                      geometry = { 
                                   kind = 'canoND',
                                   object = { origin = {0.0, 0.0, 0.0} }
                                 }
                   }
}

