import os
import glob

plot = []
show_plot = True

folders = glob.glob('./harvest_*')
ref_folders = glob.glob('./reference_harvest_*')

# The files to post-process
files='mie_scatter_track_p*_t*.res'
ref_files='reference_' + files

style = [ 
         'k-', 'b-', 'g-', 'r-','c-','m-','y-',  
         'k-.', 'b-.', 'g-.', 'r-.','c-.','m-.','y-.', 
         'k-x', 'b-x', 'g-x', 'r-x','c-x','m-x','y-x',
        ]

# Displacement field Z
count = 1
for i in folders:
  start = False
  end = False
  if count == 1:
    start = True
  if count == len(folders):
    end = True
  label= i.replace("./harvest_order"," order = ")
  label= label.replace("_level"," level = ")
  label= label.replace("_filter"," filter = ")
  plot.append(dict(kind = 'xy',data=[ i + '/' + files ],
           row=[1,-1],col=[1,6],  
           startplot = start,endplot =end,ls = style[count-1], 
           figname = 'plots/displacement_z', format='eps',
           xlabel='x', ylabel='displacement - Z', 
           label=label ))
  count=count+1

# Magnetic field X
count = 1
for i in folders:
  start = False
  end = False
  if count == 1:
    start = True
  if count == len(folders):
    end = True
  label= i.replace("./harvest_order"," order = ")
  label= label.replace("_level"," level = ")
  label= label.replace("_filter"," filter = ")
  plot.append(dict(kind = 'xy',data=[ i + '/' + files ],
           row=[1,-1],col=[1,7],  
           startplot = start,endplot =end,ls = style[count-1], 
           figname = 'plots/magnetic_x', format='eps',
           xlabel='x', ylabel='magnetic - X', 
           label=label ))
  count=count+1

# Magnetic field Y
count = 1
for i in folders:
  start = False
  end = False
  if count == 1:
    start = True
  if count == len(folders):
    end = True
  label= i.replace("./harvest_order"," order = ")
  label= label.replace("_level"," level = ")
  label= label.replace("_filter"," filter = ")
  plot.append(dict(kind = 'xy',data=[ i + '/' + files ],
           row=[1,-1],col=[1,8],  
           startplot = start,endplot =end,ls = style[count-1], 
           figname = 'plots/magnetic_y', format='eps',
           xlabel='x', ylabel='magnetic - Y', 
           label=label ))
  count=count+1

# Displacement field Z (error)
count = 1
for i in folders:
  start = False
  end = False
  if count == 1:
    start = True
  if count == len(folders):
    end = True
  label= i.replace("./harvest_order"," order = ")
  label= label.replace("_level"," level = ")
  label= label.replace("_filter"," filter = ")
  plot.append(dict(kind = 'function',data=[ i + '/' + files ],
           row=[1,-1],col=[1,6,10],  
           fun = lambda *x:abs(x[1]-x[2]),
           startplot = start,endplot =end,ls = style[count-1], 
           figname = 'plots/error_displacement_z', format='eps',
           xlabel='x', ylabel='error displacement - Z', 
           ylogscale = True,
           label=label ))
  count=count+1

# Magnetic field X (error)
count = 1
for i in folders:
  start = False
  end = False
  if count == 1:
    start = True
  if count == len(folders):
    end = True
  label= i.replace("./harvest_order"," order = ")
  label= label.replace("_level"," level = ")
  label= label.replace("_filter"," filter = ")
  plot.append(dict(kind = 'function',data=[ i + '/' + files ],
           row=[1,-1],col=[1,7,11],  
           fun = lambda *x:abs(x[1]-x[2]),
           startplot = start,endplot =end,ls = style[count-1], 
           figname = 'plots/error_magnetic_x', format='eps',
           xlabel='x', ylabel='error magnetic - X', 
           ylogscale = True,
           label=label ))
  count=count+1

# Magnetic field Y (error)
count = 1
for i in folders:
  start = False
  end = False
  if count == 1:
    start = True
  if count == len(folders):
    end = True
  label= i.replace("./harvest_order"," order = ")
  label= label.replace("_level"," level = ")
  label= label.replace("_filter"," filter = ")
  plot.append(dict(kind = 'function',data=[ i + '/' + files ],
           row=[1,-1],col=[1,8,12],  
           fun = lambda *x:abs(x[1]-x[2]),
           startplot = start,endplot =end,ls = style[count-1], 
           figname = 'plots/error_magnetic_y', format='eps',
           xlabel='x', ylabel='error magnetic - Y', 
           ylogscale = True,
           label=label ))
  count=count+1
