require('ateles')

name = 'mie_scatter'

-- define the input
mievar = {
   center = { x_circle_center, y_circle_center },
   radius = radius,
   permeaPermit_background = {cube_permea_back, cube_permit_back},
   permeaPermit_cylinder = {cube_permea_circ, cube_permit_circ},
   frequency = frequency,
   nCoeffs = nCoeffs
}

refZ = { kind = 'miescatter_displacementfieldz' }
for k,v in pairs(mievar) do refZ[k] = v end

refX = { kind = 'miescatter_magneticfieldx' }
for k,v in pairs(mievar) do refX[k] = v end

refY = { kind = 'miescatter_magneticfieldy' }
for k,v in pairs(mievar) do refY[k] = v end

input = {
    read = 'restart/mie_scatter_lastHeader.lua',
    
    -- define the subsampling parameters
    subsampling = {
        levels = post_level,
        projection = 'QLegendrePoint'
    },
    add_variable = {
        {
            name = 'ref_miescatter_displacementfieldz',
            ncomponents = 1,
            ref_miescatter_displacementfieldz = refZ
        }, 
        {
            name = 'ref_miescatter_magneticfieldx',
            ncomponents = 1,
            ref_miescatter_magneticfieldx = refX
        },
        {
            name = 'ref_miescatter_magneticfieldy',
            ncomponents = 1,
            ref_miescatter_magneticfieldy = refY
        }
    }
}

-- Variables to visualize:
req_var = {
    {'displacementField'},
    {'magneticField'},
    {'ref_miescatter_displacementfieldz'},
    {'ref_miescatter_magneticfieldx'},
    {'ref_miescatter_magneticfieldy'},
    { name = 'difference', ncomponents = 1, dep = {'displacementField_Z','ref_miescatter_displacementfieldz'}},
    --{ name = 'difference', ncomponents = 1, dep = {'magneticField_X','ref_miescatter_magneticfieldx'}},
    --{ name = 'difference', ncomponents = 1, dep = {'magneticField_Y','ref_miescatter_magneticfieldy'}},
}

segs = cubeLength/post_elemsize

sect_of_interest = {
    kind = 'canoND',
    object = {
        origin = { eps-4*elemsize, eps-4*elemsize, eps },
        vec = {
            {8*elemsize-2*eps,0,0},
            {0,8*elemsize-2*eps,0},
        },
        segments = {segs, segs},
    }
}

-- define the output
output = { 
    folder = 'harvest/',

    { -- Visualize 2D comlete domain

        format = 'VTU',

        binary = true,
        vrtx = {},
        requestedData = { variable = req_var },
        shape = sect_of_interest
    },

    { -- Tracking values over a line

         label = '_track',
         format = 'ASCII',

         requestedData = {
             variable = {
                 name = 'difference',
                 ncomponents = 1,
                 dep = {'displacementField_Z',
                        'ref_miescatter_displacementfieldz'}
             }
         },
         reduction = {'l2norm'}
         shape = sect_of_interest
    }
}
