-- Configuration file for Ateles --
require('sim_params')

timestep_info = 1

-- global simulation options
simulation_name = 'mie_scatter' 
sim_control = {
                time_control = {
                  min = 0.0, 
                  max = period
                }
              }

-- Restart settings
io_buffer_size = 12
restart = { 
            read = os.getenv('RESTART_FOLDER') .. '/mie_scatter_lastHeader.lua',                                        
            write = os.getenv('FILTER_RESTART_FOLDER') .. '/',                                        
            time_control = {   
              min = sim_control.time_control.min, 
              max = sim_control.time_control.max, 
              interval = sim_control.time_control.max
            }
          }

-- the filename of the timing results i.e. output for performance measurements
timing_file = 'timing.res'        

-- Mesh definitions --
mesh = os.getenv('MESH_FOLDER') .. '/'



-- Scheme definitions --
scheme = {
    spatial =  {
               name = 'modg',          
               m = maxPolyDegree, 
               modg_space = 'Q' 
               }, 
    temporal = {
               name = 'explicitRungeKutta', 
               steps = 4,
               control = {
                          name = 'cfl', 
                          cfl  = 0.6  
                         },
               },
    stabilization = {
                         name = 'spectral_viscosity',
                         alpha = 36,
                         order = os.getenv('SPECTRAL_FILTER_ORDER'), 
                    },
}
