-- Configuration for the Cylindrical Mie Scattering Setup --
--
-- Relies on environment variables:
-- $RESTART_FOLDER
-- $MESH_FOLDER
-- $MESHLEVEL
-- $ORDER

require('sim_params')

-- Global simulation options --
simulation_name = 'mie_scatter'

sim_control = {
    time_control = { min = 0.0, max = period }
    -- period is defined in sim_params.lua
}
-- --------------------------------


-- Restart settings --
io_buffer_size = 12

restart = {
    write = os.getenv('RESTART_FOLDER'),
    time_comtrol = {
        min      = sim_control.time_control.min,
        max      = sim_control.time_control.max,
        interval = sim_control.time_control.max
    }
}
-- --------------------------------


-- Mesh definitions --
mesh = os.getenv('MESH_FOLDER')
-- --------------------------------



-- Scheme definitions --
scheme = {
    spatial = {
        name = 'modg',
        m = maxPolyDegree,
        -- maxPolyDegree is defined in scheme_params.lua
        modg_space = 'Q'
    },
    temporal = {
        name = 'explicitRungeKutta',
        steps = 4,
        control = { name = 'cfl', cfl = 0.6 }
    }
}
-- --------------------------------
