-- Configuration file for Ateles --

-- global simulation options
simulation_name = 'mag_pulse_maxwell_modg' -- the name of the simualtion
sim_control = {
                time_control = {
                  max = 4.0e-00 -- final simulation time
                }
              }

--commpattern = 'gathered_type'

-- Mesh definitions --
mesh = './mesh/'

-- Restart settings
restart = { 
--            -- file to restart from
--            read = './restart/maxwell/per_osci_maxwell_modg_lastHeader.lua',                        
--            -- folder to write restart data to
            write = './restart/',                                        
            -- temporal definition of restart write
            time_control = {   
              min = 0, 
              max = sim_control.time_control.max, 
              interval = sim_control.time_control.max/40.0
            }
          }

-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
          folder = './',                  -- the folder for the timing results
          filename = 'timing.res'         -- the filename of the timing results
         }


-- Equation definitions --
equation = {
    name   = 'maxwell',                             -- we solve maxwell's equations
    material     = {
                     -- The background permitivity and permeability
                     global = {
                                kind = 'const',
                                const = {1.0, 1.0, 0.0},
                              },
                   },
}

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg',            -- we use the weno scheme for reconstruction
               m =  5,                   -- the reconstructed polynomial is of degree 1
               modg_space = 'Q' 
               }, 
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitRungeKutta',  
               steps = 4,
               -- how to control the timestep
               control = {
                          name = 'cfl',     -- the name of the timestep control mechanism
                          cfl  = 0.001,     -- CourantFriedrichsLewy number
                         },
               },
}

-- the postion and width of the pulse for the scatter test
pulseWidth = 0.05
pulseCenter = 0.0

function iniMagneticZ(x,y,z)
  r = math.sqrt( (x-pulseCenter)^2 + (y-pulseCenter)^2 )
  return math.exp((-1.0)*r/pulseWidth)
end 

-- ...the initial condition table
initial_condition = { 
                      displacement_fieldX = 0.0,  -- displacement field , x component
                      displacement_fieldY = 0.0,  -- displacement field , y component
                      displacement_fieldZ = 0.0,  -- displacement field , z component
                      magnetic_fieldX = 0.0,  -- magnetic induction , x component
                      magnetic_fieldY = 0.0,  -- magnetic induction , y component
                      magnetic_fieldZ = iniMagneticZ,  -- magnetic induction , z component
                    }

-- ...the general projection table
projection = {
              kind = 'l2p',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattopoints = false  -- if lobatto points should be used, default = false,
                                     -- only working for chebyshev points --> fpt
              factor = 2.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
           -- blocksize = 32,        -- for fpt, default -1
           -- fftmultithread = false -- for fpt, logical, default false
             }

