-- Configuration file for Ateles --

require('seeder')


-- global simulation options
sim_control = {
              name = 'inhomogeneous_material', 
              time_control = {
                               min = 0, 
                               max = 3.0,
                               interval = {iter = 1000},
                             }
             }

-- Mesh definitions --
mesh = 'mesh/'

-- Restart settings
restart = { 
            --read = './restart/inhomogeneous_material_lastHeader.lua', 
            write = './restart/',                                        
            time_control = {   
                             min = 0, 
                             max = sim_control.time_control.max, 
                             interval = sim_control.time_control.max/100,
                   },  
          }

-- the filename of the timing results i.e. output for performance measurements
timing_file = 'timing.res'        

-- Equation definitions --
-- ... material parameters inside te circle
cube_permea_circ = 2.0
cube_permit_circ = 2.0
cube_conduc_circ = 160000.0 --40000.0 --10000.0
-- ... material parameters of the background material
cube_permea_back = 1.0
cube_permit_back = 1.0
-- ... the center of the circle
x_circle_center = elemsize/2.0
y_circle_center = elemsize/2.0
function permeability_permitivity(x,y,z,t)
  -- Calculate the distance from the circle center
  dist = math.sqrt( math.pow(x-x_circle_center,2.0) + math.pow(y-y_circle_center,2.0) )
  -- Check if the point is inside the circle
  if dist <= elemsize/2.0  then
    return { cube_permea_circ, cube_permit_circ, cube_conduc_circ }
  else
    return { cube_permea_back, cube_permit_back, 0.0 }
  end 
end
equation = {
    name   = 'maxwell_2d',                 
    material = {
                 -- Another locally varying material property
                 {
                    kind = 'lua_fun',
                    fun = permeability_permitivity,
                    shape={ 
                              kind = 'canoND', 
                              object = {
                                         origin = {eps,eps,eps},
                                         vec = {
                                                  {elemsize-2*eps,0.0,0.0},
                                                  {0.0,elemsize-2*eps,0.0},
                                                  {0.0,0.0,elemsize-2*eps},
                                               },
                                       },
                          },
                 },
                 -- The background permitivity and permeability
                 global = {
                            kind = 'const',
                            const = {cube_permea_back, cube_permit_back, 0.0},
                          },
               }, 
}

-- Check for Nans and unphysical values
check =  {
           interval = 1,
         }

-- Scheme definitions --
scheme = {
    spatial =  {
               name = 'modg_2d',          
               m = 127, --63, --31 --TODO 15,                 
               modg_space = 'Q' 
               }, 
    temporal = {
               name = 'explicitRungeKutta', 
               steps = 4,
               control = {
                          name = 'cfl', 
                          cfl  = 0.6,  
                         },
               },
}

-- ...the initial condition table. 
initial_condition = { 
                      displacement_fieldX = 0.0, -- electric field , x component
                      displacement_fieldY = 0.0, -- electric field , z component
                      magnetic_fieldZ     = 0.0, -- magnetic induction , z component
                    }

-- ...the general projection table
projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattopoints = false  -- if lobatto points should be used, default = false,
                                     -- only working for chebyshev points --> fpt
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
           -- blocksize = 32,        -- for fpt, default -1
           -- fftmultithread = false -- for fpt, logical, default false
             }

-- The definition of the current density
x_center = -cubeLength/8.0
y_center = cubeLength/8.0
-- ... pulse width in the x and y direction
width = 0.00125
-- ... peak-value of the current density
curConst = 1.0
-- ... the temporal mode
w = 10
-- ... width of the temporal ramping 
widthTime = 0.05
-- ... the starting point of the temporal ramping
t_center = -0.5 -- TODO -2.0
function current(x,y,z,t)
  r =  (x-x_center)^2.0 -- TODO + (y-y_center)^2.0 
  tRamp = ( math.tanh( (t + t_center ) / widthTime ) + 1 ) / 2.0
  cur = curConst * math.exp( -r/width ) * math.sin( 2.0*math.pi*w*t ) * tRamp
  return { 0.0, cur }
end 

-- Source terms
source = {
  currentDensity = {
    fun = current
  }
}

