-- Configuration file for Ateles --

require('seeder')


-- global simulation options
simulation = {
              name          = 'inhomogeneous_material', 
              time = {
                       useIterations = false, 
                       min = 0, 
                       max = 2.0,
                     }
             }

-- Mesh definitions --
mesh = 'mesh/'

timestep_info = 10


-- Restart settings
restart = { 
            --read = './restart/inhomogeneous_material_lastHeader.lua', 
            write = './restart/',                                        
            time = {   
                      useIterations = simulation.time.useIterations,  
                      min = 0, 
                      max = simulation.time.max, 
                      interval = simulation.time.max/20,
                   },  
          }

-- the filename of the timing results i.e. output for performance measurements
timing_file = 'timing.res'        

-- Equation definitions --
equation = {
    name   = 'maxwelldivcorrection',                 
    material           = {
                     -- Another locally varying material property
                     {
                        kind = 'const',
                        const = {2.0, 2.0, 2.0, 2.0},
                        shape={ 
                                  kind = 'canoND', 
                                  object = {
                                             origin = {eps,eps,eps},
                                             vec = {
                                                      {eps, 0.0, 0.0},
                                                      {0.0, eps, 0.0},
                                                      {0.0, 0.0, eps},
                                                   },
                                           },
                              },
                     },
                     -- The background permitivity and permeability
                     global = {
                                kind = 'const',
                                const = {1.0, 1.0, 1.0, 1.0},
                              },
                   }, 
}

-- Check for Nans and unphysical values
check =  {
           interval = 1,
         }

-- Scheme definitions --
scheme = {
    spatial =  {
               name = 'modg',          
               m = 31,
               }, 
    temporal = {
               name = 'explicitRungeKutta', 
               steps = 4,
               control = {
                          name = 'cfl', 
                          cfl  = 0.5,  
                         },
               },
}

--function magZ(x,y,z)
--  width = 0.005
--  r = math.abs( x + 0.5 )
--  return  0.1 * math.exp( -(r/width)  ) 
--end

-- ...the initial condition table. 
initial_condition = { 
                      displacement_fieldX = 0.0,          -- electric field , x component
                      displacement_fieldY = 0.0,          -- electric field , z component
                      displacement_fieldZ = 0.0,          -- electric field , z component
                      magnetic_fieldX     = 0.0,          -- magnetic induction , x component
                      magnetic_fieldY     = 0.0,          -- magnetic induction , y component
                      magnetic_fieldZ     = 0.0,  --magZ, -- magnetic induction , z component
                    }

-- ...the general projection table
projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattopoints = false  -- if lobatto points should be used, default = false,
                                     -- only working for chebyshev points --> fpt
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
           -- blocksize = 32,        -- for fpt, default -1
           -- fftmultithread = false -- for fpt, logical, default false
             }

-- The definition of the current density
x_center = -cubeLength/8.0
y_center = cubeLength/8.0
-- ... pulse width in the x and y direction
width = 0.00125
-- ... peak-value of the current density
curConst = 1.0
-- ... the temporal mode
w = 10
-- ... width of the temporal ramping 
widthTime = 0.05
-- ... the starting point of the temporal ramping
t_center = -0.5 
function curren(x,y,z,t)
  r =  (x-x_center)^2.0  
  tRamp = ( math.tanh( (t + t_center ) / widthTime ) + 1 ) / 2.0
  cur = curConst * math.exp( -r/width ) * math.sin( 2.0*math.pi*w*t ) * tRamp
  return {0.0, 0.0, cur }
end 
function charg(x,y,z,t)
  return { 0.0 }
end 

-- Source terms
source = {
  charge = {
    fun = charg
  },
  currentDensity = {
    fun = curren
  }
}

