-- Configuration file for Ateles --


-- Definition of the testcase
level = 8
-- ... length of the overall domain
lengthX = 3.0
lengthY = 3.0
lengthZ = 3.0
-- ... the magnetic permability
perma = 10
-- ... the displacement permitivity
permit = 10
-- ... charge of the dipole
Q = 1.0
-- extent of the dipole
d = 0.2
-- radius of the dipole
rad = 2.0*math.sqrt( (lengthX/(2.0^level))^2.0 + (lengthY/(2.0^level))^2.0 )
-- ... parameters for the analytic solution
w = ( 2.0*math.pi/math.sqrt(perma*permit) ) * 10.0
-- ... the temporal period of the waveguide
T = 2.0*math.pi/w

-- Definition of the analytical solution for all components of the Maxwell equation
-- ... displacement field - x component 
function displacementX(x,y,z,t)
  return 0.0
end
-- ... displacement field - y component 
function displacementY(x,y,z,t)
  return 0.0
end
-- ... displacement field - z component 
function displacementZ(x,y,z,t)
  return 0.0
end
-- ... magnetic field - x component
function magneticX(x,y,z,t)
  return 0.0
end 
-- ... magnetic field - y component
function magneticY(x,y,z,t)
  return 0.0
end 
-- ... magnetic field - z component
function magneticZ(x,y,z,t)
  return 0.0
end 
function magneticCorrection(x,y,z,t)
  -- TODO specify the analytic solution of the magnetic div correction
  return 0.0
end 
function displacementCorrection(x,y,z,t)
  -- TODO specify the analytic solution of the magnetic div correction
  return 0.0
end 

-- global simulation options
simulation_name          = 'harmonic_dipole_maxwell_divCor_weno',     -- the name of the simualtion
sim_control = {
                time_control = {
                  max = 10.0*T -- final simulation time
                }
              }

--commpattern = 'gathered_type'

-- Mesh definitions --
mesh = './'

-- Restart settings
--restart = { 
--            -- If this table is available it will read the restart file
--            -- given below.
--            read =  {
--                     folder    = './restart/maxwell/',                           -- folder of the restart file
--                     file_name = 'lastHeader.lua'                                -- the restart file to read
--                    },
--            -- If this table is available it will write a restart file
--            -- with the specified options.
--            write = {
--                     folder    = './restart/maxwell/',                           -- the folder the restart files are written to
--                     interval  = 2.5/10.0,                                      -- dump restart file interval
--                     tmin      = 0.0,                                            -- first timestep to output
--                     tmax      = 20.0                                            -- last timestep to output
--                    }
--          }

-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
          folder = './',                  -- the folder for the timing results
          filename = 'timing.res'         -- the filename of the timing results
         }


-- Equation definitions --
equation = {
    name   = 'maxwellDivCorrection',                             -- we solve maxwell's equations
    material           = {
                     -- The background permitivity and permeability
                     global = {
                                kind = 'const',
                                const = {permea, permit, 1.0, 1.0},
                              },
                   },
}

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'weno',            -- we use the weno scheme for reconstruction
               m = 1,                     -- the reconstructed polynomial is of degree 1
               }, 
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitRungeKutta',  
               steps = 4,
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.33,    -- CourantFriedrichsLewy number
                         },
               },
}

-- ...initial condition function for displacement field 
function ic_displacementX(x,y,z)
  return displacementX(x,y,z,0)
end
function ic_displacementY(x,y,z)
  return displacementY(x,y,z,0)
end
function ic_displacementZ(x,y,z)
  return displacementZ(x,y,z,0)
end
-- ...initial condition function for magnetic field 
function ic_magneticX(x,y,z)
  return magneticX(x,y,z,0)
end
function ic_magneticY(x,y,z)
  return magneticY(x,y,z,0)
end
function ic_magneticZ(x,y,z)
  return magneticZ(x,y,z,0)
end
function ic_magneticCorrection(x,y,z)
  -- TODO give a correct initial conidtion for the magnetic divergence error
  return 0.0
end 
function ic_displacementCorrection(x,y,z)
  -- TODO give a correct intial condition for the displacement divergence error
  return 0.0
end 
-- ...the initial condition table
initial_condition = { 
                      displacement_fieldX = ic_displacementX,  -- displacement field , x component
                      displacement_fieldY = ic_displacementY,  -- displacement field , y component
                      displacement_fieldZ = ic_displacementZ,  -- displacement field , z component
                      magnetic_fieldX = ic_magneticX,  -- magnetic induction , x component
                      magnetic_fieldY = ic_magneticY,  -- magnetic induction , y component
                      magnetic_fieldZ = ic_magneticZ,  -- magnetic induction , z component
                      magneticCorrection = ic_magneticCorrection, -- magnetic div correction
                      displacementCorrection = ic_displacementCorrection, -- displacement div correction
                    }

-- Source term definition, i.e. in Maxwell equations we are talking about space charges and 
-- current densities. In general they can depend on spatial coordinates and time.
function currentDensityZSpaceTime(x, y, z, t)
  -- calculate the minimal distance from the z axis
  r = math.sqrt(x^2.0+y^2.0)
  if r <= rad then
    return Q*d*w*math.sin(w*t)
  else 
    return 0.0
  end 
end
function chargeDensitySpaceTime(x, y, z, t)
  -- calculate the minimal distance from the z axis
  r = math.sqrt(x^2.0+y^2.0)
  if r <= rad then
    return Q
  else 
    return 0.0
  end 
end
source = {
  charge =                -- charge density
  {
     fun = chargeDensitySpaceTime
  },
  currentDensityX = 0.0,  -- current density, x component
  currentDensityY = 0.0,  -- current density, y component
  currentDensityZ =       -- current density, z component
  {
     fun = currentDensityZSpaceTime   
  }  
}

-- Boundary definitions
boundary_condition = {
                       { 
                         label = 'outerCylinder',   -- boundary for the outer cylinder
       -- TODO this boundary has to replaced by an open boundary
                         kind = 'pec',              
                       }
                       ,
                       {
                         label = 'periodicZ',       -- periodic boundary in the vertical direction
                         kind = 'periodic',
                       }
                     }  

