-- Sample configuration for solve_euler_riemann

-- Isentropic expansion coefficient
isen_coef = 1.4

-- State left in the order of density, velocity, pressure
left = { 1.4, 0.0, 4.0 }

-- State right in the order of density, velocity, pressure
right = { 1.4, 0.0, 1.0 }

-- Write resulting time slices into files
create_files = true

-- file_prefix = 'exact'

-- Auxilary function to read data from an ascii file
function readcsv_col(file, col)
  local fp = assert(io.open (file))
  local csv = {}
  for line in fp:lines() do
    local row = {}
    for value in line:gmatch("[^ ]*") do
      if value ~= '' then
        row[#row+1] = value
      end
    end
    csv[#csv+1] = row[col]
  end

  -- csv contains now given column from the csv file
  return csv
end

-- Points in time, where to get sample the solution:
--t = {0.0, 0.1, 0.2, 0.3, 0.4}
t = {}
for i=0,4 do
  table.insert(t, i*0.1)
end

-- Points in space, where to probe the solution in every time slice:
-- x = {-0.5, -0.4, -0.3, -0.2, -0.1, 0.0, 0.1, 0.2, 0.3, 0.4, 0.5}
x = readcsv_col('xdat.ascii', 1)

