# encoding: utf-8
#Copyright (C) 2012 J.r0ck <j69@ar156.dip.jp>

#
# 人工無能 TwitAngela5
# メインモジュール
#

require 'rubygems'
require 'twitter'
require 'yaml'
require 'log4r'
require 'log4r/formatter/patternformatter'
require 'log4r/configurator'
require 'log4r/yamlconfigurator'
require 'MeCab'
require 'classifier'
require 'stemmer'
require 'hpricot'
require 'open-uri'
require 'mechanize'
require 'json'
require 'kconv'
require 'uri'
require 'pathname'
require 'pp'

require './lib/angela_util'
require './lib/angela'
require './lib/twitter_helper'
require './lib/dict_factory'
require './lib/word'
require './lib/status_object'
require './lib/cabocha_ex'
require './lib/mecab_helper'
require './lib/crawler'
require './lib/spam_checker'
require './lib/feel_checker'
require './lib/character_checker'
require './lib/markov'
require './lib/trigram'

module TwAngela
  def doWork
    begin
      @@Log.info("TwitAngelaを起動しました...ユーザー：#{@@USERID}")
      @@Log.info("モード --> デバッグモード") if @@DEBUGMODE
      
      datetime = Time.now
      sleep(1)

      while true
        angela = Angela.new()

        if datetime < Time.now
          #ツイート
          angela.doComment

          if @@DEBUGMODE
            span = 0
          else
            span = rand(90)
          end

          datetime = datetime + span * 60
          @@Log.info("次回ツイート予定：#{datetime.to_s}")
        end

        #Mentionsに対するリプライ
        angela.doReply

        #自発的なリプライ
        if @@ISSELFREPLY && rand(100) == 0
          @@Log.info("自立リプライ発生")
          angela.doSelfReply
        end
        
        if @@DEBUGMODE
          sleep(5)
        else
          sleep(60)
        end
      
      end
    rescue => err
      @@Log.fatal("TwitAngelaがエラー終了しました。")
      @@Log.fatal(err)
    end
  end
  module_function :doWork


  #start program
  dmode = false
  if ARGV[0] == "-d"
    dmode = true
  end

  @@PWD = File.expand_path(File.dirname(__FILE__))

  @@CONFIG = YAML.load_file(basePath("config/angela.yaml"))["CONFIG"]
  raise "設定ファイル不正" if @@CONFIG == nil

  SYSCONF = @@CONFIG["SYSTEM"]
  
  @@TEMPLATE = basePath(SYSCONF["TEMPLATE"])
  @@DATAFILE = basePath(SYSCONF["DATA_FILE"])
  @@TLFILE = basePath(SYSCONF["TL_FILE"])
  @@MENTFILE = basePath(SYSCONF["MENT_FILE"])
  @@REPLAYLOG = basePath(SYSCONF["REPLAY_LOG"])
  @@BAYES = basePath(SYSCONF["BAYES"])
  @@FEELING = basePath(SYSCONF["FEELING"])
  @@CHARACTER = basePath(SYSCONF["CHARACTER"])
  @@KEYWORDS = basePath(SYSCONF["KEYWORDS"])
  @@CRAWFILE = basePath(SYSCONF["CRAW_FILE"])
  
  @@DATAROW = SYSCONF["DATA_ROW"]
  @@MENTROW = SYSCONF["MENT_ROW"]
  if dmode
    @@DEBUGMODE = true
  else
    @@DEBUGMODE = SYSCONF["DEBUG_MODE"]
  end
  @@USERID = @@CONFIG["USER_ID"]
  @@USEKAOMOJI = @@CONFIG["USE_KAOMOJI"]
  @@REPLAYTERMDAY = @@CONFIG["REPLAY_TERM_DAY"]
  @@CHARA = @@CONFIG["CHARACTER"]
  @@ISSELFREPLY = @@CONFIG["IS_SELF_REPLY"]
  @@ISTRANSLATE = @@CONFIG["IS_TRANSLATE"]
  
  Log4r::YamlConfigurator["LOGDIR"] = basePath(SYSCONF["LOG_DIR"])
  Log4r::YamlConfigurator.load_yaml_file(basePath(SYSCONF["LOG4R_CONF"]))
  @@Log = Log4r::Logger.get('angela')

  @@DATE_FORMAT = "%Y %m %d %H %M %S"
  
  if @@DEBUGMODE
    doWork()
  else
    Process.daemon
    doWork()
  end
end
