# encoding: utf-8
require 'classifier'
require 'stemmer'
require 'MeCab'
require 'pathname'
require 'hpricot'
require 'open-uri'
require 'mechanize'
require 'json'
require 'kconv'
require 'uri'
require 'twitter'


class TwitterHelper
  
  def initialize()
    login()
  end

  def login()
    Twitter.configure do |config|
      config.consumer_key = 'xxxxxxxxxxxxxxxxxxxx'
      config.consumer_secret = 'xxxxxxxxxxxxxxxxxxxx'
      config.oauth_token = "xxxxxxxxxxxxxxxxxxxx"
      config.oauth_token_secret = "xxxxxxxxxxxxxxxxxxxx"
      end 
  end

  #https://dev.twitter.com/docs/api/1/get/statuses/user_timeline
  def dumpUserTimeline(user, row=190)
    while true
      data = []
      begin
        Twitter.user_timeline(user, {"count" => row}).each do |r|
          data << r.text
        end
        return data
      rescue => err
        p err
      end
    end
  end
  
end

class String
  alias_method :original_stem, :stem
  def stem
    self.original_stem.force_encoding(self.encoding)
  end
end

class MeCab::Tagger
  alias_method :original_parse, :parse
  def parse(text)
    original_parse(text).force_encoding(text.encoding)
  end
end

def writeFile(file, val, mode)
  begin
    f = File.open(file, mode)
    case val
    when Array
      val.each {|line|
        f.puts line
      }
    when String
      f.puts val
    end
  ensure
    f.close
  end
end

def removeTag(str)
  return str if str == nil
  return str.gsub(/#[\s]?.+/, " ")
end

def removeUser(str)
  return str if str == nil
  return str.gsub(/[@＠]\w+/, " ")
end

def removeUrl(str)
  return str if str == nil
  return str.gsub(/http[s]?\:\/\/[\w\+\$\;\?\.\%\,\!\#\~\*\/\:\@\&\\\=\_\-]+/, " ")
end

def removeRt(str)
  return str if str == nil
  return str.gsub(/((RT)|(QT))[\s]?\w+/, " ").gsub(/(RT)|(QT)/, " ")
end

def removeTags(str)
  str = removeTag(str)
  str = removeUser(str)
  str = removeUrl(str)
  str = removeRt(str)

  # 連続する空白や先頭の空白削除
  str = str.gsub(/\s+/, ' ').gsub(/^\s/, '').gsub(/^　/, '')
  # 改行削除
  str = str.gsub(/\n/, '')

  #DoCoMo
  str = str.gsub(/[\xEE\x98\x80-\xEE\x9D\xBF]/, '')
  #au
  str = str.gsub(/[\xEE\xB1\x80-\xEF\x83\xBF]/, '')
  #SoftBank
  str = str.gsub(/[\xEE\x80\x80-\xEE\x94\xBF]/, '')
  
  # 括弧関連は削除
  str = str.gsub(/(＼.*／)|(\[.*\])|(【.*】)|(『.*』)|(《.*》)|(（.*）)|(［.*］)|(\(.*\))|｛.*｝|(‘.*’)|(“.*”)|(〈.*〉)|(〔.*〕)|(〝.*〟)/, '')
  # 要らない文字　※結局取りきれなかった顔文字の残骸など
  str = str.gsub(/[■・「」”":：→←↑↓*※／＼ωε｀´Σ゜Д∀；ヽノ○ゝヾ]/, '')

  str.strip!
  return str == nil ? '' : str 
end

# Twitter検索演算子
# 演算子の例    指定される検索条件
# twitter 検索  「twitter」と「検索」を両方含むツイート。これはデフォルトの演算子です。
# "おはよう。今日も"    「おはよう。今日も」という単語をそのまま含むツイート。
# 阪神 OR タイガース    「阪神」、あるいは「タイガース」（又は両方）を含むツイート。
# 阪神 -タイガース  「阪神」を含むが、「タイガース」を含まないツイート。
# #haiku    「#haiku」というハッシュタグを含むツイート。
# from:twj  「twj」というユーザーに送信されたツイート。
# to:techcrunch 「techcrunch」宛てに送信されたツイート。
# @twedasuke    「twedasuke」というユーザー宛ての@ツイート。
# 野球 near:新宿駅  「野球」というフレーズを含め、「新宿駅」周辺で送信されたツイート。
# near:新宿 within:15km 「新宿」から 15Km 半径で送信されたツイート。
# 芸能人 since:2010-12-27   「芸能人」を含み、"2010-12-27" (年-月-日) 以降に送信されたツイート。
# なう until:2010-12-27 「なう」を含み、"2009-10-22" (年-月-日) 以前に送信されたツイート。
# 映画 -ホラー :)   「映画」を含むが、「ホラー」を含まず、内容がポジティブなツイート。
# フライト :(   「フライト」を含み、内容がネガティブなツイート。
# 渋滞 ?    「渋滞」を含み、内容が疑問形のツイート。
# うける filter:links   「うける」と共にリンクが含まれたツイート。
# ニュース source:twitterfeed   「ニュース」が含まれ、TwitterFeed から送信されたツイート。
def crawlTwitter(keyword, file, category)
  isTag = false
  if keyword[0] == '#'
    isTag = true
    keyword = keyword[1, keyword.length - 1]
    url = "http://search.twitter.com/search.json?lang=ja&rpp=69&q=%23" + URI.encode(keyword)
  elsif keyword[0] == '@'
    isTag = true
    keyword = keyword[1, keyword.length - 1]
    url = "http://search.twitter.com/search.json?lang=ja&rpp=69&q=from%3A%40" + URI.encode(keyword)
  else
    case category
      #when 'happy'
      #when 'surprise'
      when 'sad', 'anger', 'hatred', 'fear'
        url = "http://search.twitter.com/search.json?lang=ja&rpp=69&q=" + URI.encode(keyword) + '+-' + URI.encode('笑')
      else
        url = "http://search.twitter.com/search.json?lang=ja&rpp=69&q=" + URI.encode(keyword) 
    end
  end
  p url
  
  while true
    begin
      sentence = []
      agent = Mechanize.new()
      page = agent.get(url)
      js = JSON.parse(page.body)
      js['results'].each {|result|
        text = result['text']
        text = Hpricot(text, :xhtml_strict => true).to_plain_text
    
        if text && !text.empty?
          line = text.split(/\n/)
          line.each do |t|
            if isTag
              t = removeTags(t)
              sentence << t unless t.strip.empty?
            else
              regex = Regexp.escape(keyword)
              if t =~ /#{regex}/
                t = removeTags(t)
                sentence << t unless t.strip.empty?
              end
            end
          end
        end
      }
      break
    rescue => err
      p err
    end
  end
  
  p keyword
  p sentence.size
  
  writeFile(file, sentence, 'a') if sentence.length > 0
end

def crawUserTimeline(file, user)
  sentence = []
  tw = TwitterHelper.new
  data = tw.dumpUserTimeline(user)
  
  data.each do |text|
    if text && !text.empty?
      line = text.split(/\n/)
      line.each do |t|
        #if t =~ /#{keyword}/
          t = removeTags(t)
          sentence << t unless t.strip.empty?
        #end
      end
    end
  end
  
  p user
  p sentence.size
  
  writeFile(file, sentence, 'w') if sentence.length > 0
end

def train(bayes, wakati, category, text)
  parsed = wakati.parse(text)
  bayes.train(category, parsed)
end

#***************************
# 学習開始
#***************************
wakati = MeCab::Tagger.new('-O wakati')

p '############################################################'
p 'SPAM学習'
p 'SPAMと表現しているが、迷惑なものではなく学習したくない広告などのこと'
p '############################################################'

ptrn = ['spam', 'ham']
query = {}
query['spam'] = ['@maniacav', '@nyoshin_av', '相互フォロー', '本日トップニュースを提供してくれたみなさん', '引き上げシワ', 'ヤフーオークション', '@Digital_QB', '@hsbc_otasuke', '@pochita_tokyo', '@cpstyle_funa', '@R_san_bot', '拡散', '急募', '#クーポン', '#ホットペッパー', '#求人', '#派遣', '#アルバイト', '#オークション', '#ニュース']
query['ham'] = ['@souseki_meigen', '@osamu_dazai', '@aozorabot', '@matayoshi0', '@piston2438', '@tomo_coco73', '@__69__']

bayes = Classifier::Bayes.new()

ptrn.each do |category|
  bayes.add_category(category)
  File.delete("learn/#{category}.txt") if File.exists?("learn/#{category}.txt")
  
  query[category].each do |k|
    crawlTwitter(k, "learn/#{category}.txt", category)
  end

  open("learn/#{category}.txt") {|file|
    while line = file.gets
      line = line.strip
      unless line.empty?
        train(bayes, wakati, category, line)
      end
    end
  }
end

# ダンプ
Pathname.new('learn/spam.dump').open('wb') do |f|
  Marshal.dump(bayes, f)
end

p '############################################################'
p '感情学習'
p '############################################################'

feels = ['happy', 'surprise', 'fear', 'sad', 'anger', 'hatred', 'shame', ]
query = {}
query['happy'] = ['恋', '慕', '憂', '愉', '懐', '良', '嬉', '楽', '甘', '美味', '好', '幸', 'たのしい', 'うれしい', 'しあわせだ', 'めでたい', 'はずかしい', 'さわやかだ', 'いつくしい', 'いとおしい', 'このむ', 'よろこぶ', 'うれえる','よろこび', 'ハッピー', 'おはよう', 'おやすみ', 'ラッキー','よっしゃ', 'ありがと', 'やった', '面白', 'おもしろ', 'うまい', 'おいし', 'わーい', 'よい天気', 'いい天気', ]
query['surprise'] = ['ビックリ', 'びっくり', '吃驚', '驚いた', '驚き', 'えー', 'マジ', 'すごい', 'すげぇ', '本当', 'ほんと', 'げっ', 'げろげろ', ]
query['fear'] = ['恐', '怪', '怖', 'おそろしい', 'こわい', 'おそれる', 'あやしむ', 'びびる', 'うらむ', 'うらみ', 'お化け', ]
query['sad'] = ['忌', '忍', '悲', '愁', '惜', '悼', '寂', '泣', '涙', '悔', 'かなしい', 'うらがなしい', 'ものがなしい', 'みじめだ', 'やるせない', 'かなしむ', 'かなしみ', 'かなしい', 'さみしい', 'くやしい', '負け', '辛い', 'つらい', '貧乏', '死んだ', '寒い', '疲れた', '死ぬ', ]
query['anger'] = ['怒', '憎', '憤', '恨', 'にくたらしい', 'いかる', 'おこる', 'いきどおる', 'むかつく', 'いかり', '腹立', 'いらつく', '苛つく', 'イラつく', '畜生', 'ちくしょ', 'ふざけ', 'このやろ', 'コノヤロ', '死ね', 'こら', 'にくむ', 'うらむ', 'うらみ', ]
query['hatred'] = ['嫌', '好きじゃない', 'いやだ', 'きらい', 'キライ', '困った', '無理', '鬱', '嫌悪', '最悪', '死ぬ', 'きらう', 'けぎらいする', 'めでる', 'うんざりする', 'あきる', ]
query['shame'] = ['恥', 'はじらう', 'はにかむ', 'はずかいし', 'はにかむ', 'とほほ', '汗', '赤面', ]

bayes = Classifier::Bayes.new()

feels.each do |category|
  bayes.add_category(category)
  File.delete("learn/#{category}.txt") if File.exists?("learn/#{category}.txt")
  
  query[category].each do |k|
    crawlTwitter(k, "learn/#{category}.txt", category)
  end

  open("learn/#{category}.txt") {|file|
    while line = file.gets
      line = line.strip
      unless line.empty?
        train(bayes, wakati, category, line)
      end
    end
  }
end

# ダンプ
Pathname.new('learn/feel.dump').open('wb') do |f|
  Marshal.dump(bayes, f)
end

p '############################################################'
p 'キャラ学習'
p '############################################################'

char = ['char_a', 'char_b', 'char_c', 'char_d']
query = {}
query['char_a'] = ['matayoshi0']
query['char_b'] = ['piston2438']
query['char_c'] = ['tomo_coco73']
query['char_d'] = ['__69__']

bayes = Classifier::Bayes.new()

char.each do |category|
  bayes.add_category(category)
  File.delete("learn/#{category}.txt") if File.exists?("learn/#{category}.txt")
  
  query[category].each do |k|
    crawUserTimeline("learn/#{category}.txt", k)
  end

  open("learn/#{category}.txt") {|file|
    while line = file.gets
      line = line.strip
      unless line.empty?
        train(bayes, wakati, category, line)
      end
    end
  }
end

# ダンプ
Pathname.new('learn/character.dump').open('wb') do |f|
  Marshal.dump(bayes, f)
end


p '************************************************************'
p '感情テストモード開始（q:終了）'
p '************************************************************'

require "readline"
while buf = Readline.readline("> ", true)
    if buf == 'q'
      break
    end
    
    print "-> ", buf, "\n"

    parsed = wakati.parse(buf)
    
    chara = nil
    feel = nil
    spam = nil
    
    Pathname.new('learn/character.dump').open('rb') do |f|
      chara = Marshal.load(f)
    end

    Pathname.new('learn/feel.dump').open('rb') do |f|
      feel = Marshal.load(f)
    end

    Pathname.new('learn/spam.dump').open('rb') do |f|
      spam = Marshal.load(f)
    end
   
    p 'キャラクタ ->'
    p chara.classifications(parsed).inspect
    p chara.classify(parsed)

    p '感情 ->'
    p feel.classifications(parsed).inspect
    p feel.classify(parsed)

    p 'spam ->'
    p spam.classifications(parsed).inspect
    p spam.classify(parsed)
end


