# encoding: utf-8
#Copyright (C) 2012 J.r0ck <j69@ar156.dip.jp>

#
# 人工無能 TwitAngela5
# TwitterAPI関連の支援クラス
#

module TwAngela

  class TwitterHelper
    include TwAngela
    
    def initialize()
      login()
    end

    def login()
      oauthToken = @@CONFIG["OAUTH_TOKEN"]
      oauthTokenSecret = @@CONFIG["OAUTH_TOKEN_SECRET"]

      Twitter.configure do |config|
        config.consumer_key = 'xxxxxxxxxxxxxxxxxxxx'
        config.consumer_secret = 'xxxxxxxxxxxxxxxxxxxx'
        config.oauth_token = oauthToken
        config.oauth_token_secret = oauthTokenSecret
      end 
    end

    #https://dev.twitter.com/docs/api/1/get/statuses/home_timeline
    def dumpTimeline(file, row)
      begin
        f = File.open(file,'w')
        Twitter.home_timeline({"count" => row}).each do |r|
          writeLine(f, r) unless r.text.empty?
        end
      rescue => err
        @@Log.error("Timeline取得でエラーが発生しました。")
        @@Log.error(err)
      ensure
        f.close if f != nil
      end
    end

    #https://dev.twitter.com/docs/api/1/get/statuses/user_timeline
    def dumpUserTimeline(file, user, row)
      begin
        f = File.open(file, 'w')
        Twitter.user_timeline(user, {"count" => row}).each do |r|
          writeLine(f, r) unless r.text.empty?
        end
      rescue => err
        @@Log.error("UserTimeline取得でエラーが発生しました。")
        @@Log.error(err)
      ensure
        f.close if f != nil
      end
    end
    
    #https://dev.twitter.com/docs/api/1/get/statuses/mentions
    def dumpMentions(file, row)
      begin
        f = File.open(file, 'w')
        Twitter.mentions({"count" => row}).each do |r|
          writeLine(f, r) unless r.text.empty?
        end
      rescue => err
        @@Log.error("Mentions取得でエラーが発生しました。")
        @@Log.error(err)
      ensure
        f.close if f != nil
      end
    end

    #https://dev.twitter.com/docs/api/1/get/statuses/mentions
    def getMentions
      mentions = []
      begin
        #Twitter.mentions({"count" => 100, "trim_user" => true}).each do |r|
        Twitter.mentions({"count" => 100}).each do |r|
          mentions << r unless r.text.empty?
        end
      rescue => err
        @@Log.error("Mentions取得でエラーが発生しました。")
        @@Log.error(err)
      end
      return mentions
    end

    #https://dev.twitter.com/docs/api/1/get/direct_messages
    def dumpDirectMessage(file, row)
      begin
        f = File.open(file, 'w')
        Twitter.direct_messages({"count" => row}).each do |r|
          writeLine(f, r) unless r.text.empty?
        end
      rescue => err
        @@Log.error("DM取得でエラーが発生しました。")
        @@Log.error(err)
      ensure
        f.close if f != nil
      end
    end

    #トレンド取得
    def getTrends(woeid)
      trends = []
      begin
        Twitter.local_trends(woeid).each do |r|
          trends << r.name  
        end
      rescue => err
        @@Log.error("トレンド取得でエラーが発生しました。")
        @@Log.error(err)
      end
      return trends
    end

    def getUser(ids)
      users = []
      if ids.length > 0
        begin
          Twitter.users(ids).each do |r|
            users << r  
          end
        rescue => err
          @@Log.error("ユーザー情報取得でエラーが発生しました。")
          @@Log.error(err)
        end
      end
      return users
    end
    
    #ツイート実行
    def comment(str, opt={})
      begin
        unless @@DEBUGMODE
          Twitter.update(str, opt)
        else
          writeFile(@@PWD + "/log/tw.log", str, 'a')
        end
      rescue => err
        @@Log.error("ツイートでエラーが発生しました。")
        @@Log.error(err)
      end
    end

    def writeLine(f, r)
      text = r.text.gsub($/, "").gsub(/\t/, "")
      f.puts "#{r.id.to_s}\t#{getGtm(r.created_at)}\t#{r.user.screen_name}\t#{text}\t#{r.user.name}"
    end
    private :writeLine
     
  end

end

