# encoding: utf-8
#Copyright (C) 2012 J.r0ck <j69@ar156.dip.jp>

#
# 人工無能 TwitAngela5
# 広告などのspamチェックを行うクラス
#

module TwAngela

  class SpamChecker
    include TwAngela
    
    def initialize()
      Pathname.new(@@BAYES).open('rb') do |f|
        @spambayes = Marshal.load(f)
      end
      @wakati = MecabHelper.new('-O wakati')
    end

    # spamチェック
    def checkSpam(str)
      type = @spambayes.classify(@wakati.parse(str))
      if type == 'Spam'
        @@Log.debug("spam -> #{str}")
        return true
      end
      return false
    end
    
    def checkSpams(list)
      return list.reject{|e| checkSpam(e)} 
    end

  end
end

