# encoding: utf-8
#Copyright (C) 2012 J.r0ck <j69@ar156.dip.jp>

#
# 人工無能 TwitAngela5
# 文章の感情チェックを行うクラス
#

module TwAngela

  class FeelChecker
    include TwAngela
    
    def initialize()
      @feel = nil
      Pathname.new(@@FEELING).open('rb') do |f|
        @feel = Marshal.load(f)
      end
      @wakati = MecabHelper.new('-O wakati')
      
    end

    def checkFeel(str)
      data = removeTags(str)
      emo = @feel.classify(@wakati.parse(data))
      @@Log.info("感情 -> #{emo}") if @@DEBUGMODE
      return emo
    end

    def feels
      # 幸福感、驚き、恐れ、悲しみ、怒り、嫌悪
      return ['Happy', 'Surprise', 'Fear', 'Sad', 'Anger', 'Hatred']
    end
    
  end
end

