# encoding: utf-8
#Copyright (C) 2012 J.r0ck <j69@ar156.dip.jp>

#
# 人工無能 TwitAngela5
# 文章の感情チェックを行うクラス
#

module TwAngela

  class CharacterChecker
    include TwAngela
    
    def initialize()
      @char = nil
      Pathname.new(@@CHARACTER).open('rb') do |f|
        @char = Marshal.load(f)
      end
      @wakati = MecabHelper.new('-O wakati')
      
    end

    def checkChara(str)
      data = removeTags(str)
      parsed = @wakati.parse(data)
      chara = @char.classify(parsed).downcase.gsub(' ', '_')

      if @@CHARA == chara
        @@Log.info("キャラクター -> #{chara}") if @@DEBUGMODE
        return true
      end
      @@Log.info("否キャラクター -> #{chara}") if @@DEBUGMODE
      return false
    end

    def chars
      return ['char_a', 'char_b', 'char_c']
    end
    
  end
end

