# encoding: utf-8
#Copyright (C) 2012 J.r0ck <j69@ar156.dip.jp>

#
# 人工無能 TwitAngela4
# ユーティリティ
#
require 'date'

module TwAngela

  def basePath(path)
    return @@PWD + "/" + path
  end
  module_function :basePath

  #ファイルに文字列を出力
  def writeFile(file, val, mode)
    begin
      f = File.open(file, mode)
      case val
      when Array
        val.each {|line|
          f.puts line
        }
      when String
        f.puts val
      end
    rescue => err
      @@Log.error("writeFileでエラーが発生しました。")
      @@Log.error(err)
    ensure
      f.close
    end
  end
  module_function :writeFile

  #顔文字データの取得
  def setKaomoji(res, template)
    len = res.split(//u).length
    
    if @@USEKAOMOJI
      return res if len > 100
      return res if res =~ /[。!！？?⁈]$/
      
      feel = FeelChecker.new
      emo = feel.checkFeel(res)
      kaomoji = template['face'][emo]
      
      5.times{
        moji = kaomoji[rand(kaomoji.size)]
        return res + ' ' + moji if len + moji.split(//u).length < 120
      }
    end
    
    return res
  end
  module_function :setKaomoji

  def forEnglish(str)
    str << ' ' if str =~/[0-9A-Za-z]$/
    return str      
  end
  module_function :forEnglish
    
  def getChgSubject(template, str)
    data =  template['replace']['Change']
    token = data[rand(data.size)]
    return token.gsub('$0', str)
  end
  module_function :getChgSubject

  def getPrefix(template, emo)
    data =  template['prefix'][emo]
    return data[rand(data.size)]
  end
  module_function :getPrefix

  def getBody(template, emo)
    data =  template['body'][emo]
    return data[rand(data.size)]
  end
  module_function :getBody
  
  #日時を文字列で取得
  def getGtm(dt)
    return "" if dt == nil
    return dt.strftime(@@DATE_FORMAT)
  end
  module_function :getGtm

  def removeTag(str)
    return str if str == nil
    return str.gsub(/#[\s]?.+/, " ")
  end
  module_function :removeTag

  def removeUser(str)
    return str if str == nil
    return str.gsub(/[@＠]\w+/, " ")
  end
  module_function :removeUser

  def replaceUser(str)
    return str if str == nil
    dummy = [ 'うさぎさん', 'かめさん', 'だるまさん', ]
    return str.gsub(/[@＠]\w+\s?　?さん/, dummy[rand(dummy.length)])
  end
  module_function :replaceUser

  def removeUrl(str)
    return str if str == nil
    return str.gsub(/http[s]?\:\/\/[\w\+\$\;\?\.\%\,\!\#\~\*\/\:\@\&\\\=\_\-]+/, " ")
  end
  module_function :removeUrl

  def removeRt(str)
    return str if str == nil
    return str.gsub(/((RT)|(QT))[\s]?\w+/, " ").gsub(/(RT)|(QT)/, " ")
  end
  module_function :removeRt

  def removeTags(str)
    str = replaceUser(str)
    str = removeTag(str)
    str = removeUser(str)
    str = removeUrl(str)
    str = removeRt(str)

    #顔文字の削除を試みる
    s = ''
    mecab = MecabHelper.new
    words = mecab.analyze(str)
    words.each do |word|
      case (word.feature[0])
      when '名詞'
        if word.feature[1] == '数'
          if word.next? && word.next.feature[0] == '名詞' && word.next.feature[1] == '一般'
            next
          end
        end
        
        if word.pre? && word.pre.feature[0] == '助詞' && word.pre.feature[1] == '格助詞'
          s << forEnglish(word.token)
          next
        end
        
        unless (word.feature[1] == 'サ変接続' || word.feature[1] == '一般' ) && word.feature[8] == nil
          s << forEnglish(word.token)
          next
        end
      when '記号'
        unless word.feature[1] == '一般' && (word.feature[8] == nil || word.feature[8] == '顔文字')
          s << forEnglish(word.token)
          next
        end
      else
        s << forEnglish(word.token)
        next
      end
    end
    
    str = s

    # 連続する空白の削除
    str = str.gsub(/[\s　]+/, '')
    # 改行削除
    str = str.gsub(/\n/, '')

    #DoCoMo
    str = str.gsub(/[\xEE\x98\x80-\xEE\x9D\xBF]/, '')
    #au
    str = str.gsub(/[\xEE\xB1\x80-\xEF\x83\xBF]/, '')
    #SoftBank
    str = str.gsub(/[\xEE\x80\x80-\xEE\x94\xBF]/, '')
    
    # 括弧関連は削除
    str = str.gsub(/(＼.*／)|(●.*●)|(★.*★)|(\[.*\])|(【.*】)|(『.*』)|(《.*》)|(（.*）)|(［.*］)|(\(.*\))|｛.*｝|(‘.*’)|(“.*”)|(〈.*〉)|(〔.*〕)|(〝.*〟)/, '')
    str = str.gsub(/[\[\]【】『』《》（）［］\(\)｛｝〈〉〔〕〝〟]/, '')
    # 要らない文字　※結局取りきれなかった顔文字の残骸など
    str = str.gsub(/[■・「」”":：→←↑↓*※／＼ωε｀´Σ゜Д∀；ヽノ○ゝヾ▽д…ゞ]|(┣¨)|(TT)|(ΤΔΤ)/, '')
    str = str.gsub(/。。。/, '。')
    str = str.gsub(/[\d]+$/, '')

    str.strip!
    return str == nil ? '' : str 
  end
  module_function :removeTags
  
  def getBiorythms(birthday)
    pi = 3.1415
    bday = Date.strptime(birthday, "%Y/%m/%d")
    tday = Date.today
    days = (tday - bday).to_i
    bio = {}
    bio[:physical] = Math::sin(pi * 2 * days / 23)
    bio[:sensitivity] = Math::sin(pi * 2 * days / 28)
    bio[:intellectual] = Math::sin(pi * 2 * days / 33)
    return bio
  end
  module_function :getBiorythms

end
