# encoding: utf-8
#Copyright (C) 2012 J.r0ck <j69@ar156.dip.jp>

#
# 人工無能 TwitAngela5
# Angelaのインスタンス
#

class String
  alias_method :original_stem, :stem
  def stem
    self.original_stem.force_encoding(self.encoding)
  end
end

module TwAngela

  class Angela
    include TwAngela

    @@RESPONS_LOG = []
    @@MAX_LOGING = 50
    
    def initialize()
      @template = YAML.load_file(@@TEMPLATE)
    end

    def storeBayes(key, sentences, bayes)
      if sentences
        sentences.uniq!
        wakati = MecabHelper.new('-O wakati')
        sentences.each do |item|
          r = removeTags(item)
          unless r.empty? || r == '\n'
            bayes.train(key, wakati.parse(r))
          end
        end
      end
    end
    private :storeBayes

    def storeCrawData(sentences)
      if sentences
        sentences.uniq!
        sentences.each do |item|
          r = removeTags(item)
          unless r.empty? || r == '\n'
            writeFile(@@CRAWFILE, r, 'a')
          end
        end
      end
    end
    private :storeCrawData

    def crawKeywords(dic, mimicry = 0.6)
      parsed = ''
      dic.keywords.each do |w|
        next if w.nil? || w.empty?
        bayes = craw(w)
        if bayes
          parsed = parse(bayes, mimicry, '')
          break unless parsed.empty?
        end
      end
      return parsed
    end
    private :crawKeywords

    def craw(w)
      File.delete(@@CRAWFILE) if File.exists?(@@CRAWFILE)
      
      bayes = Classifier::Bayes.new
      bayes.add_category(w)

      spamcheker = SpamChecker.new
      crawler = Crawler.new
      
      sentence = []  

      @@Log.info("craw対象キーワード：#{w}")

      res = crawler.crawlWiki(w)
      res.reject!{|e| spamcheker.checkSpam(e)} if res
      sentence.concat(res) if res 

      res = crawler.crawlHatena(w)
      res.reject!{|e| spamcheker.checkSpam(e)} if res 
      sentence.concat(res) if res 

      # はてなとWikiの検索結果からベイズ作成
      storeBayes(w, sentence, bayes) 

      # Twitter検索
      res = crawler.crawlTwitter(w)
      res.reject!{|e| spamcheker.checkSpam(e)} if res
      sentence.concat(res) if res 

      storeCrawData(sentence)
      
      @@Log.info("検索結果件数：#{sentence.length.to_s}")
      return bayes
    end

    #ツイート
    def doComment
      tw = TwitterHelper.new
      dic = DictFactory.new
      
      dic.analyzeTimeline
      res = crawKeywords(dic, 0.55)
      
      unless res.empty?
        if @@ISTRANSLATE && res.split(//u).length < 50
          res = randamTranslate(res)
        end
        twieet = setKaomoji(res, @template)
        tw.comment(twieet)
        @@Log.info(">ツイート：#{twieet}")
      else
        @@Log.info(">ツイートなし")
      end
    end
    
    def retryParse(emo)
      bayes = nil
      dic = DictFactory.new
      dic.analyzeTimeline
      dic.keywords.each do |w|
        bayes = craw(w)
        break if bayes
      end

      r = rand(3)
      case r
        when 0
          prefix = getPrefix(@template, emo).strip
          res = parse(bayes, 0.9, prefix)
        when 1
          res = getBody(@template, emo).strip
        else
          res = getChgSubject(@template, bayes.categories[0])
      end
    end
    private :retryParse
    
    #リプライ
    def doReply
      tw = TwitterHelper.new
      dic = DictFactory.new
      tw.dumpMentions(@@MENTFILE, @@MENTROW) unless @@DEBUGMODE

      preuser = ''
      createTargets.each {|target|
        r = rand(3)
        if (preuser == target.user)
          r -= 1
        end
        
        if r > 0
          feel = FeelChecker.new
          emo = feel.checkFeel(target.token)
          
          answers = makeAnswer(target.token)
          if answers.length < 1
            dic.analyzeMentions(target)
            res = crawKeywords(dic, 0.9)
            res = retryParse(emo) if res.empty?

            res = "@#{target.user} #{res}"
            twieet = setKaomoji(res, @template)
          else
            res = answers[rand(answers.length)]
            twieet = "@#{target.user} #{res}"
          end

          tw.comment(twieet, :in_reply_to_status_id => target.id.to_i)
          @@Log.info(">ターゲット：#{target.token}")
          @@Log.info(">感情推測：#{emo}")
          @@Log.info(">リプレイ：#{twieet}")
        else
          @@Log.info(">ターゲット：#{target.token}")
          @@Log.info(">感情推測：#{emo}")
          @@Log.info(">リプレイなし：#{target.user}")
        end

        pushId(target.id)
        preuser = target.user
      }
      
    end

    #自立リプライ
    def doSelfReply
      tw = TwitterHelper.new
      dic = DictFactory.new
      
      dic.analyzeTimeline
      target = getTargetStatus(dic)
      
      res = ''
      if target
        feel = FeelChecker.new
        emo = feel.checkFeel(target.token)
        
        answers = makeAnswer(target.token)        
        if answers.length > 0
          res = answers[rand(answers.length)]

          twieet = "#{res} RT @#{target.user}: #{target.token}"
          twieet = twieet.split(//u)[0..140].join('')
          tw.comment(twieet, :in_reply_to_status_id => target.id.to_i)
          @@Log.info(">ターゲット：#{target.token}")
          @@Log.info(">ユーザー：#{target.user}")
          @@Log.info(">感情推測：#{emo}")
          @@Log.info(">自立RT：#{twieet}")
        else
          dic.analyzeMentions(target)
  
          i = 0
          while i < 3
            res = crawKeywords(dic, 0.9)
            res = retryParse(emo) if res.empty?

            trg = Trigram.new(target.token)
            p1 = trg.analyze(res)
  
            @@Log.info(">オウム返しポイント：#{p1}")
            if p1 < 0.6
              res = "@#{target.user} #{res}"
              twieet = setKaomoji(res, @template)
              tw.comment(twieet, :in_reply_to_status_id => target.id.to_i)
              @@Log.info(">ターゲット：#{target.token}")
              @@Log.info(">ユーザー：#{target.user}")
              @@Log.info(">感情推測：#{emo}")
              @@Log.info(">自立リプレイ：#{twieet}")
              break
            end
            
            i += 1
          end
        end
      end
    end

    def makeAnswer(sentence)

      return [] unless rand(20) == 0
      
      @@Log.info("回答パース中...")
      answers = []
      parser = CaboCha::Parser.new
      tree = parser.parse(sentence.to_s)
      tree.chunks.each do |chunk|
        # 主語と述語を抜き出す
        if chunk.next_chunk && chunk.subject?
          if chunk.next_chunk.next_chunk.nil? || chunk.next_chunk.tokens[chunk.next_chunk.tokens.length - 1].feature_list(1) == '句点'

            if chunk.next_chunk.verb?
              answers << "う〜ん、#{chunk.to_noun}〜(；ﾟдﾟ)"
              answers << "#{chunk.to_s}#{chunk.next_chunk.to_katei}ばよくね？"
              answers << "#{chunk.to_s}#{chunk.next_chunk.to_renyo}たい..."
              answers << "#{chunk.to_s}#{chunk.next_chunk.to_renyo}ます。"
              answers << "#{chunk.to_noun}は#{chunk.next_chunk.to_renyo}はじめた..."
              answers << "#{chunk.to_noun}は#{chunk.next_chunk.to_renyo}続けている..."
              answers << "#{chunk.to_s}#{chunk.next_chunk.to_rentai}ふりをしている(´Д｀)"
              answers << "#{chunk.to_noun}は#{chunk.next_chunk.to_negative}ですよね┐(´∀｀)┌ﾔﾚﾔﾚ"
            elsif chunk.next_chunk.noun?
              answers << "#{chunk.to_noun}は#{chunk.next_chunk.to_base}になったの？"
            elsif chunk.next_chunk.adjective?
              answers << "#{chunk.to_noun}は#{chunk.next_chunk.to_base.gsub(/い$/,'')}くなった？"
            end
          end
        end
      end

      #一定期間内で同じ発言していないか？
      answers.reject!{ |e| checkRepeat(e) }
      @@Log.info("回答パース完了...#{answers.length}")
      @@Log.info(answers.length) if @@DEBUGMODE

      return answers
    rescue
      return []
    end
    private :makeAnswer
    
    def getTargetStatus(dic)
      data = []
      spamcheker = SpamChecker.new

      #TLからキーワードに関してつぶやいているステータスを取得
      @@Log.info("ターゲットステータス検索...")
      tls = []
      open(@@TLFILE) {|file|
        while line = file.gets
          next if line =~ /(RT)/

          line.strip!
          unless line.empty?
            linedata = line.split(/\s*\t\s*/)
            unless spamcheker.checkSpam(linedata[3])
              token = removeTags(linedata[3])
              token = token.gsub('　', ' ')
              so = StatusObject.new
              so.token = token
              so.user = linedata[2]
              so.id = linedata[0]
              tls << so
            end
          end
        end
      }

      dic.keywords.each do |w|
        tls.each do |so|
          if so.token.index(w)
            data << so
            break if data.length >= 50
          end
        end
      end
      tls = []

      #ユーザーのリスト作成
      @@Log.info("ユーザーのリスト作成...")
      users = []      
      data.each do |so|
        users << so.user unless users.index(so.user)
      end

      #mentionsに存在するユーザー取得
      @@Log.info("Mentionsのユーザーのリスト作成...")
      tw = TwitterHelper.new
      mentions = [] 
      tw.getMentions.each do |m|
        mentions << m.user['screen_name'] unless mentions.index(m.user['screen_name'])
      end

      #リスト分のユーザー情報取得、条件に当てはまらないユーザーのつぶやきは削除
      tw.getUser(users).each do |tu|
        unless mentions.index(tu.screen_name)
          unless tu.followers > 10000 && tu.friends < 1000
            data.reject!{|e| e.user == tu.screen_name}
          end
        end
      end
      
      #自分は除く
      data.reject!{|e| e.user == @@USERID}
      
      @@Log.info("ターゲットユーザー数：#{data.length}")
      return nil if data.length == 0
      return data[rand(data.length)]
    end
    private :getTargetStatus
    
    def addKTT(line)
      line = line.gsub(/^　/, '')
      line = line.gsub(/　$/, '')
      unless line =~ /[.・。、,!?！？]$/
        line << '。'
      end
      return line
    end
    private :addKTT
    
    def mixAnswer(sentence)
      answers = []
      parser = CaboCha::Parser.new
      tree = parser.parse(sentence.to_s)
      tree.chunks.each do |chunk|
        patn = ''
        ng = false
        if chunk.next_chunk && chunk.subject_non_verb? 
          n = chunk.next_chunk
          while true
            unless n
              ng = false
              break
            end
            if n.tokens[0].feature_list(0) == '助詞' && (n.tokens[0].feature_list(1) == '格助詞' || n.tokens[0].feature_list(1) == '連体化')
              ng = true
            end
            patn << n.to_s unless n.to_s =~ /[。、]/
            n = n.next_chunk
          end
          answers << patn unless patn == '' || ng
        end
      end
      return answers.uniq
    end
    private :mixAnswer

    def parse(bayes, mimicry = 0.6, prefix = '')
      data = []

      return '' unless File.exists?(@@CRAWFILE)
      
      mecab = MecabHelper.new
      wakati = MecabHelper.new('-O wakati')

      open(@@CRAWFILE) {|file|
        while line = file.gets
          line = line.strip
          unless line.empty?
            line = line.gsub(/^[\s！？!?]/, '')
            words = mecab.analyze(line)
            if words && words.length > 0
              unless words[0].feature[0] =~ /^助/
                data << line
              end
            end
          end
        end
      }

      if data.length > 0
        answers =[]
        data.sort_by{rand}
        
        # データ候補が少ない場合に増殖
        if data.length < 10
          data.each do |r|
            answers = mixAnswer(r)
            answers.each do |t|
              @@Log.info("増殖A -> #{t}") if @@DEBUGMODE
            end
            data += answers
          end
        end
        
        spamchecker = SpamChecker.new
        respons = []
        len = 20
        rate = 2
        
        len.times {
          lines = []
          
          i = 1
          if data.length <= rate
            data.each do |row|
              unless i == rate
                row = addKTT(row)
              end
              
              lines << row
              i += 1
            end
          else
            rands = [ 0, ]
            rate.times {
              while true
                r = rand(data.length)
                unless rands.index(r)
                  rands << r
                  break
                end
              end
              row = data[rands[rands.length - 1]]
              if i < rate
                row = addKTT(row)
              end
              
              lines << row
              i += 1
            }
          end

          org = lines.join('')

          # マルコフ連鎖を数回繰り返し、一番ネタ文章に似ていない候補を取得          
          com = ''
          dp = 10 # 類似点
          10.times {
            dest = createComment(org)
            dest.strip!
            if dest.split(//u).length > 0
              # ネタ文章との相違性チェック
              trg = Trigram.new(org)
              p1 = trg.analyze(dest)
              if dp > p1
                dp = p1
                com = dest
              end
            end
          }

          if dp < mimicry
            unless com.gsub(/[\s　]/, '') == org.gsub(/[\s　]/, '') && com.split(//u).length > 15
              com = prefix + com
              
              # SAPM判定とループチェック
              unless spamchecker.checkSpam(com) || checkLoop(com)
                # キャラクタ判定
                cc = CharacterChecker.new
                if cc.checkChara(com)
                  candidate = [ com, org, 0 ]
                  bayes.classifications(wakati.parse(com)).each_value do |point|
                    point = 0 if point > 0
                    unless com.split(//u).length == 0
                      candidate[2] = point / com.split(//u).length
                      respons << candidate
                    end
                  end
                  
                  # 候補増殖
                  mixAnswer(com).each do |t|
                    candidate = [ t, org, 0 ]
                    bayes.classifications(wakati.parse(t)).each_value do |point|
                      point = 0 if point > 0
                      unless t.split(//u).length < 10
                        candidate[2] = point / t.split(//u).length
                        respons << candidate
                      end
                    end
                  end
                end
              end
            end
          end
        }

        array = respons.sort {|a, b| a[2] <=> b[2] }
        array.each do |r|
          @@Log.info("候補 -> #{r[2]} #{r[0]}") if @@DEBUGMODE
        end
        
        token = ''
        i = 1
        len = rand(30) + 50

        while i < array.length
          res = array[array.length - i]
          token = replaces(res[0])

          if token.split(//u).length < len
            #一定期間内で同じ発言していないか？
            if checkRepeat(token)
              @@Log.info("発言済み -> #{token}") if @@DEBUGMODE
              res = nil
              i += 1
            else
              trg = Trigram.new(res[1])
              p1 = trg.analyze(token)
              @@Log.info("ネタ -> #{res[1]}") if @@DEBUGMODE 
              @@Log.info("ネタ度 -> #{p1}") if @@DEBUGMODE 
              @@Log.info("採点 -> #{res[2]}") if @@DEBUGMODE 
              bufferLog(token)
              break
            end
          else
            @@Log.info("長過ぎる -> #{len} | #{token}") if @@DEBUGMODE
            res = nil
            i += 1
          end
        end
      end
      
      return token
    end
    private :parse
    
    def bufferLog(res)
      @@RESPONS_LOG << res
      @@RESPONS_LOG.shift if @@RESPONS_LOG.size > @@MAX_LOGING
    end
    private :bufferLog

    def checkRepeat(str)
      trg = Trigram.new(str)

      b = false
      @@RESPONS_LOG.each do |log|
        p1 = trg.analyze(log)
        if p1 > 0.6
          b = true
          break
        end
      end
      
      @@Log.info("発言済み -> #{str}") if b
      
      return b
    end
    private :checkRepeat
    
    def checkLoop(str)
      i = 0
      str.scan(/./).each do |w|
        pos = str.index(w, i + 1)
        if pos
          len = pos - i - 1
          token = str.split(//u)[i, len].join('')
          if token.length > 1
            if str.scan("#{token}").length > 1
              @@Log.info("ループ -> #{token}") if @@DEBUGMODE
              return true
            end
          end
        end
        i += 1
      end
      return false
    end
    private :checkLoop
    
    def replaces(token)
      token = removeTags(token)
      
      mecab = MecabHelper.new
      words = mecab.analyze(token)

      rep = ''
      words.each do |word|
        if word.feature[0] == '名詞' && word.feature[1] == '代名詞'
          if word.feature[7] =~ /(アタシ)|(アタイ)|(アチキ)|(ワタシ)|(オレ)|(ボク)|(オイラ)|(ワシ)|(ワシャ)/
            rep << @template['replace']['My']
          else
            rep << word.token
          end
        else
          rep << word.token
        end
      end
      
      return rep
    end
    
    def createComment(str)
      markov = Markov.new
      return markov.parse(str)
    end
    private :createComment
    
    #リプレイターゲット作成
    def createTargets
      targets = []
      responslog = loadLog()

      open(@@MENTFILE) {|file|
        while line = file.gets
          line = line.strip
          if !line.empty?
            linedata = line.split(/\s*\t\s*/)
            #リプレイログになければ...
            if responslog.index(linedata[0]) == nil
              obj = StatusObject.new()
              obj.id = linedata[0]
              obj.create_at = linedata[1]
              obj.user = linedata[2]
              obj.token = removeTags(linedata[3])
              obj.name = linedata[4]

              if (DateTime.now - obj.getCreateAt()) < @@REPLAYTERMDAY
                targets.push(obj)
                @@Log.info("リプレイターゲット作成：#{obj.id} #{obj.create_at} #{obj.user}")
              else
                pushId(obj.id)
                @@Log.debug("リプレイターゲット外：#{obj.id} #{obj.create_at} #{obj.user}")
              end
            end
          end
        end
      }
      return targets
    end
    private :createTargets

    def loadLog()
      data = []

      if File.exist?(@@REPLAYLOG)
        open(@@REPLAYLOG) {|file|
          while line = file.gets
            line = line.strip
            data.push(line)
          end
        }
      end

      return data
    end
    private :loadLog

    #リプレイ済みまたは有効期限切れの情報をロギング
    def pushId(id)
      maxrow = 100
      responslog = loadLog()
      
      while responslog.size >= maxrow
        responslog.shift
      end

      responslog.push(id)

      begin
        f = File.open(@@REPLAYLOG, 'w')
        responslog.each {|line|
          f.puts line
        }
      ensure
        f.close if f != nil
      end
    end
    private :pushId
 
    def randamTranslate(str)
      if rand(10) == 0
        langs = [ 'ar', 'bg', 'ca', 'zh-CHS', 'zh-CHT', 'cs', 'da', 'nl', 'en', 'et', 'fi', 'fr', 'de', 'el', 'ht', 'he', 'hi', 'hu', 'id', 'it', 'ko', 'lv', 'lt', 'no', 'pl', 'pt', 'ro', 'ru', 'sk', 'sl', 'es', 'sv', 'th', 'tr', 'uk', 'vi', ]
        craw = Crawler.new()
        t = craw.crawlTranslate(str, "ja", langs[rand(langs.size)])
        return str if t == nil
        return t
      end
      return str
    end
    private :randamTranslate
       
  end
end

